/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ResourceUtil;
import com.jetbrains.cidr.lang.inspections.CidrInspectionToolProvider;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInspectionUtil {
    private static final Logger LOG = Logger.getInstance(OCInspectionUtil.class);

    private OCInspectionUtil() {
    }

    @Nullable
    public static HighlightSeverity getHighlightSeverity(@NotNull Class<? extends OCInspectionBase> inspectionClass, @Nullable PsiElement element, @NotNull HighlightSeverity defaultHighlightSeverity) {
        if (inspectionClass == null) {
            OCInspectionUtil.$$$reportNull$$$0(0);
        }
        if (defaultHighlightSeverity == null) {
            OCInspectionUtil.$$$reportNull$$$0(1);
        }
        if (OCInspectionBase.OtherObjCMarker.class.isAssignableFrom(inspectionClass) || OCInspectionBase.OtherCppMarker.class.isAssignableFrom(inspectionClass) || element == null) {
            return defaultHighlightSeverity;
        }
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)element.getProject());
        InspectionProfileImpl inspectionProfile = profileManager.getCurrentProfile();
        String inspectionShortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
        if (inspectionShortName == null) {
            return null;
        }
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.find((String)inspectionShortName);
        if (!inspectionProfile.isToolEnabled(highlightDisplayKey, element) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (highlightDisplayKey == null) {
            return defaultHighlightSeverity;
        }
        HighlightDisplayLevel highlightDisplayLevel = inspectionProfile.getErrorLevel(highlightDisplayKey, element);
        return highlightDisplayLevel.getSeverity();
    }

    @Nullable
    public static String getInspectionShortName(@NotNull Class<? extends LocalInspectionTool> inspectionClass) {
        if (inspectionClass == null) {
            OCInspectionUtil.$$$reportNull$$$0(2);
        }
        try {
            return inspectionClass.newInstance().getShortName();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.warn("Cannot get inspection short name: " + e);
            return null;
        }
    }

    @Nullable
    @Nls
    public static String getStaticDescription(@NotNull OCInspectionBase inspection) {
        String shortName;
        if (inspection == null) {
            OCInspectionUtil.$$$reportNull$$$0(3);
        }
        if ((shortName = OCInspectionUtil.getInspectionShortName(inspection.getInspectionClass())) != null) {
            try {
                InputStream descriptionStream = ResourceUtil.getResourceAsStream((ClassLoader)((Object)((Object)inspection)).getClass().getClassLoader(), (String)"inspectionDescriptions", (String)(shortName + ".html"));
                return descriptionStream != null ? ResourceUtil.loadText((InputStream)descriptionStream) : null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "";
    }

    public static boolean isInspectionEnabled(@NotNull Project project, @Nullable Class<? extends OCInspectionBase> inspectionClass) {
        if (project == null) {
            OCInspectionUtil.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (inspectionClass == null) {
            return false;
        }
        String shortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
        HighlightDisplayKey key = shortName != null ? HighlightDisplayKey.find((String)shortName) : null;
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        return inspectionProfile.isToolEnabled(key, null);
    }

    public static void setInspectionEnabled(@NotNull Project project, @Nullable Class<? extends OCInspectionBase> inspectionClass, boolean enabled) {
        if (project == null) {
            OCInspectionUtil.$$$reportNull$$$0(5);
        }
        if (inspectionClass == null) {
            return;
        }
        String shortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
        if (shortName != null) {
            InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            inspectionProfile.setToolEnabled(shortName, enabled, project);
        }
    }

    public static boolean isClangdDFAEnabled(@NotNull PsiElement element) {
        if (element == null) {
            OCInspectionUtil.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)element.getProject());
        InspectionProfileImpl inspectionProfile = profileManager.getCurrentProfile();
        return Arrays.stream(CidrInspectionToolProvider.getInstance().getInspectionClasses()).filter(c -> OCInspectionUtil.isClangdDFAInspection(c)).anyMatch(arg_0 -> OCInspectionUtil.lambda$isClangdDFAEnabled$1((InspectionProfile)inspectionProfile, element, arg_0));
    }

    @NotNull
    public static List<Class<? extends OCInspectionBase>> setClangdDFADisabled(@NotNull Project project) {
        if (project == null) {
            OCInspectionUtil.$$$reportNull$$$0(7);
        }
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        ArrayList<Class<? extends OCInspectionBase>> disabledList = new ArrayList<Class<? extends OCInspectionBase>>();
        for (Class<? extends LocalInspectionTool> c : CidrInspectionToolProvider.getInstance().getInspectionClasses()) {
            HighlightDisplayKey key;
            if (!OCInspectionUtil.isClangdDFAInspection(c)) continue;
            String shortName = OCInspectionUtil.getInspectionShortName(c);
            HighlightDisplayKey highlightDisplayKey = key = shortName != null ? HighlightDisplayKey.find((String)shortName) : null;
            if (key == null || !inspectionProfile.isToolEnabled(key)) continue;
            disabledList.add(c);
            inspectionProfile.setToolEnabled(shortName, false, project);
        }
        ArrayList<Class<? extends OCInspectionBase>> arrayList = disabledList;
        if (arrayList == null) {
            OCInspectionUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static boolean isClangdDFAInspection(Class<?> klass) {
        if (!OCInspectionBase.DataFlowAnalysisMarker.class.isAssignableFrom(klass)) {
            return false;
        }
        try {
            OCInspectionBase inspection = (OCInspectionBase)((Object)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            return inspection.getMainToolId() != null && inspection.worksWithClangd();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    private static /* synthetic */ boolean lambda$isClangdDFAEnabled$1(InspectionProfile inspectionProfile, PsiElement element, Class c) {
        String shortName = OCInspectionUtil.getInspectionShortName(c);
        HighlightDisplayKey highlightDisplayKey = shortName != null ? HighlightDisplayKey.find((String)shortName) : null;
        return highlightDisplayKey != null && inspectionProfile.isToolEnabled(highlightDisplayKey, element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHighlightSeverity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCInspectionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCInspectionUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setClangdDFADisabled";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightSeverity";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionShortName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStaticDescription";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInspectionEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setInspectionEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isClangdDFAEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setClangdDFADisabled";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

