/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainConstraint;
import com.jetbrains.sourceglider.scripts.rml.DomainTypeReference;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprBinary;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RelExprQuantify
extends RelExpr {
    public static final int EXIST = 0;
    public static final int FOR_ALL = 1;
    private int opCode;
    private String quantifier;
    private DomainConstraint[] domainConstraints;
    private RelExpr expr;
    private DomainTypeReference typeRef;

    public RelExprQuantify(int opCode, String quantifier, DomainTypeReference typeRef, RelExpr expr, Context context, Nonterm nonterm) {
        super(context, nonterm);
        this.opCode = opCode;
        this.quantifier = quantifier;
        this.expr = expr;
        this.typeRef = typeRef;
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        IRelation result;
        long startMillis = System.currentTimeMillis();
        DomainType type = this.typeRef.resolve(variablesManager);
        Domain domain = domainsPool.computeBestDomain(variablesManager, this.quantifier, type, this.domainConstraints);
        domainsPool.pushDomain(domain);
        variablesManager.storeDomain(this.quantifier, domain);
        if (this.opCode == 0) {
            IRelation opResult = this.expr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
            result = opResult.exists(domain, threadCallback);
            opResult.kill();
        } else if (this.opCode == 1) {
            ArrayList<RelExprQuantify> quantifiers = new ArrayList<RelExprQuantify>();
            RelExpr curExpr = this;
            while (curExpr instanceof RelExprQuantify && curExpr.opCode == 1) {
                quantifiers.add(0, (RelExprQuantify)curExpr);
                curExpr = curExpr.expr;
            }
            if (curExpr instanceof RelExprBinary && ((RelExprBinary)curExpr).getOpCode() == 2) {
                ArrayList<Domain> domains = new ArrayList<Domain>();
                for (RelExprQuantify quantifier : quantifiers) {
                    if (quantifier != this) {
                        DomainType curType = quantifier.typeRef.resolve(variablesManager);
                        Domain curDomain = domainsPool.computeBestDomain(variablesManager, quantifier.quantifier, curType, quantifier.domainConstraints);
                        domains.add(curDomain);
                        domainsPool.pushDomain(curDomain);
                        variablesManager.storeDomain(quantifier.quantifier, curDomain);
                        continue;
                    }
                    domains.add(domain);
                }
                IRelation leftResult = ((RelExprBinary)curExpr).getLeftOperand().interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
                IRelation rightResult = ((RelExprBinary)curExpr).getRightOperand().interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
                IRelation rightResultComplement = rightResult.complement(threadCallback);
                IRelation faComplement = leftResult.unsafeIntersect(rightResultComplement, threadCallback);
                IRelation exists = leftResult;
                for (Domain curDomain : domains) {
                    IRelation faOld = faComplement;
                    IRelation exOld = exists;
                    faComplement = faComplement.exists(curDomain, threadCallback);
                    exists = exists.exists(curDomain, threadCallback);
                    faOld.kill();
                    exOld.kill();
                }
                IRelation forAll = faComplement.complement(threadCallback);
                result = exists.unsafeIntersect(forAll, threadCallback);
                exists.kill();
                forAll.kill();
                faComplement.kill();
                rightResultComplement.kill();
                rightResult.kill();
                for (Domain curDomain : domains) {
                    if (curDomain == domain) continue;
                    domainsPool.popDomain(curDomain);
                }
                for (RelExprQuantify quantifier : quantifiers) {
                    if (quantifier == this) continue;
                    variablesManager.removeDomain(quantifier.quantifier);
                }
            } else {
                IRelation opResult = this.expr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
                IRelation opNotResult = opResult.complement(threadCallback);
                IRelation oldResult = result = opNotResult.exists(domain, threadCallback);
                result = result.complement(threadCallback);
                opResult.kill();
                opNotResult.kill();
                oldResult.kill();
            }
        } else {
            throw new UnsupportedOperationException("Unknown op code " + this.opCode);
        }
        variablesManager.removeDomain(this.quantifier);
        domainsPool.popDomain(domain);
        if (profileManager != null) {
            long duration = System.currentTimeMillis() - startMillis;
            profileManager.addDuration(this, duration, result.getNumOfBDDNodes());
        }
        return result;
    }

    @Override
    public void collectDomainConstraints(Map<String, List> constraints, VariablesManager variablesManager) {
        ArrayList myConstraints = new ArrayList();
        constraints.put(this.quantifier, myConstraints);
        this.expr.collectDomainConstraints(constraints, variablesManager);
        this.domainConstraints = ArrayHelper.castArray(myConstraints.toArray(), DomainConstraint.class);
    }
}

