/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.internal.statistic.utils.EventRateThrottleResult;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/utils/EventsRateWindowThrottle;", "", "threshold", "", "periodMs", "", "startTime", "(IJJ)V", "count", "lastPeriod", "incrementCounter", "", "resetCounter", "period", "setThreshold", "newThreshold", "tryPass", "Lcom/intellij/internal/statistic/utils/EventRateThrottleResult;", "now", "intellij.platform.statistics"})
public final class EventsRateWindowThrottle {
    private int count;
    private long lastPeriod;
    private int threshold;
    private final long periodMs;

    public final void setThreshold(int newThreshold) {
        this.threshold = newThreshold;
    }

    @NotNull
    public final synchronized EventRateThrottleResult tryPass(long now) {
        long period = now / this.periodMs;
        if (period != this.lastPeriod) {
            this.resetCounter(period);
            return EventRateThrottleResult.ACCEPT;
        }
        if (this.count < this.threshold) {
            this.incrementCounter();
            return EventRateThrottleResult.ACCEPT;
        }
        if (this.count == this.threshold) {
            this.incrementCounter();
            return EventRateThrottleResult.DENY_AND_REPORT;
        }
        return EventRateThrottleResult.DENY;
    }

    private final void incrementCounter() {
        int n = this.count;
        this.count = n + 1;
    }

    private final void resetCounter(long period) {
        this.count = 1;
        this.lastPeriod = period;
    }

    public EventsRateWindowThrottle(int threshold, long periodMs, long startTime) {
        this.threshold = threshold;
        this.periodMs = periodMs;
        this.lastPeriod = startTime / this.periodMs;
    }
}

