/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.actions.OpenEventsSchemeFileAction;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogTestMetadataPersistence;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/statistic/actions/OpenEventsTestSchemeFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myRecorderId", "", "(Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "event", "intellij.platform.statistics.devkit"})
final class OpenEventsTestSchemeFileAction
extends DumbAwareAction {
    private final String myRecorderId;

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        presentation.setEnabled(StatisticsRecorderUtil.isTestModeEnabled((String)this.myRecorderId));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        Path path = new EventLogTestMetadataPersistence(this.myRecorderId).getEventsTestSchemeFile();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"EventLogTestMetadataPers\u2026rId).eventsTestSchemeFile");
        Path file = path;
        OpenEventsSchemeFileAction.Companion.openFileInEditor(file, project2);
    }

    public OpenEventsTestSchemeFileAction(@NotNull String myRecorderId) {
        Intrinsics.checkNotNullParameter((Object)myRecorderId, (String)"myRecorderId");
        super(StatisticsBundle.message((String)"stats.open.0.test.scheme.file", (Object[])new Object[]{myRecorderId}), ActionsBundle.message((String)"group.OpenEventsTestSchemeFileAction.description", (Object[])new Object[0]), AllIcons.FileTypes.Any_type);
        this.myRecorderId = myRecorderId;
    }

    public /* synthetic */ OpenEventsTestSchemeFileAction(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "FUS";
        }
        this(string);
    }

    public OpenEventsTestSchemeFileAction() {
        this(null, 1, null);
    }
}

