/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.http;

import a.d.la;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpHeaderDocumentation {
    private static final String CC_LICENSE = " is licensed under <a href=\"https://creativecommons.org/licenses/by-sa/2.5/\">CC-BY-SA 2.5</a>.";
    private static final String URL_PREFIX = "https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/";
    private static final String RFC_PREFIX = "https://tools.ietf.org/html/rfc";
    private final String myName;
    private final String myRfc;
    private final String myRfcTitle;
    private final String myDescription;
    private final boolean myIsDeprecated;
    private static final long a = la.a(-9217067792218577188L, -5670823074087789386L, MethodHandles.lookup().lookupClass()).a(200413534833439L);

    private HttpHeaderDocumentation(String name, String rfc, String rfcTitle, String description, boolean isDeprecated) {
        this.myName = name;
        this.myRfc = rfc;
        this.myRfcTitle = rfcTitle;
        this.myDescription = description;
        this.myIsDeprecated = isDeprecated;
    }

    @Nullable
    public static HttpHeaderDocumentation read(@NotNull JsonObject obj) {
        String string;
        long l2 = a ^ 0x35039492509FL;
        if (obj == null) {
            HttpHeaderDocumentation.a(0);
        }
        if (StringUtil.isNotEmpty((String)(string = HttpHeaderDocumentation.a(obj, "name")))) {
            String string2 = HttpHeaderDocumentation.a(obj, "rfc-title");
            String string3 = HttpHeaderDocumentation.a(obj, "rfc-ref");
            String string4 = HttpHeaderDocumentation.a(obj, "descr");
            JsonElement jsonElement = obj.get("obsolete");
            boolean bl2 = jsonElement != null && jsonElement.isJsonPrimitive() && jsonElement.getAsBoolean();
            return new HttpHeaderDocumentation(string, string3, string2, string4, bl2);
        }
        return null;
    }

    @NotNull
    private static String a(@NotNull JsonObject jsonObject, @NotNull String string) {
        JsonElement jsonElement;
        if (jsonObject == null) {
            HttpHeaderDocumentation.a(1);
        }
        if (string == null) {
            HttpHeaderDocumentation.a(2);
        }
        return (jsonElement = jsonObject.get(string)) != null && jsonElement.isJsonPrimitive() ? jsonElement.getAsString() : "";
    }

    @Nullable
    public String generateDoc() {
        long l2 = a ^ 0x3388237B35BEL;
        if (StringUtil.isNotEmpty((String)this.myDescription)) {
            StringBuilder stringBuilder = new StringBuilder().append(this.myDescription);
            if (StringUtil.isNotEmpty((String)this.myRfc) && StringUtil.isNotEmpty((String)this.myRfcTitle)) {
                stringBuilder.append("<br/><br/>");
                stringBuilder.append("<a href=\"").append(RFC_PREFIX).append(this.myRfc).append("\">").append(this.myRfcTitle).append("</a>");
            }
            String string = this.getUrl();
            stringBuilder.append("<br/><br/>");
            stringBuilder.append("<a href=\"").append(string).append("\">").append(this.getName()).append("</a> by ");
            stringBuilder.append("<a href=\"").append(string).append("$history").append("\">").append("Mozilla Contributors").append("</a>");
            stringBuilder.append(CC_LICENSE);
            return stringBuilder.toString();
        }
        return null;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            HttpHeaderDocumentation.a(3);
        }
        return string;
    }

    public boolean isDeprecated() {
        return this.myIsDeprecated;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            HttpHeaderDocumentation.a(4);
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        String string = URL_PREFIX + this.getName();
        if (string == null) {
            HttpHeaderDocumentation.a(5);
        }
        return string;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x8618D5BCE69L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/http/HttpHeaderDocumentation";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/http/HttpHeaderDocumentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAsString";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

