/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Version
implements Comparable<Version>,
Serializable {
    private static final Map<String, Integer> SPECIAL_VALUES = new HashMap<String, Integer>();
    @NotNull
    private final int[] elements;
    public static final Version ZERO;

    public static Version of(@NotNull String string) {
        String[] substrings;
        if (string == null) {
            Version.$$$reportNull$$$0(0);
        }
        ArrayList<Integer> b = new ArrayList<Integer>(5);
        for (String ss : substrings = string.split("[.,\\-_ ]|(?<=\\d)(?!\\d)|(?<!\\d)(?=\\d)")) {
            String ss2 = ss.trim().toLowerCase(Locale.ENGLISH);
            if (ss2.isEmpty()) continue;
            Integer special = SPECIAL_VALUES.get(ss2);
            if (special != null) {
                b.add(special);
                continue;
            }
            try {
                Integer v = new Integer(ss2);
                b.add(v);
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        if (b.isEmpty()) {
            throw new IllegalArgumentException("Failed to parse version \"" + string + "\"");
        }
        if (b.size() == 1 && (Integer)b.get(0) == 0) {
            return ZERO;
        }
        return Version.of(b.toArray(new Integer[b.size()]));
    }

    public static Version of(int ... elements) {
        int n;
        if (elements == null) {
            Version.$$$reportNull$$$0(1);
        }
        for (n = elements.length; n > 0 && elements[n - 1] == 0; --n) {
        }
        if (n == 0) {
            return ZERO;
        }
        int[] ownElements = Arrays.copyOf(elements, n);
        return new Version(ownElements);
    }

    public static Version of(@NotNull Integer[] elements) {
        int n;
        if (elements == null) {
            Version.$$$reportNull$$$0(2);
        }
        for (n = elements.length; n > 0 && elements[n - 1] == 0; --n) {
        }
        if (n == 0) {
            return ZERO;
        }
        int[] ownElements = new int[n];
        for (int i = 0; i < n; ++i) {
            ownElements[i] = elements[i];
        }
        return new Version(ownElements);
    }

    private Version(@NotNull int[] elements) {
        if (elements == null) {
            Version.$$$reportNull$$$0(3);
        }
        this.elements = elements;
    }

    public int get(int index) {
        return index < this.elements.length ? this.elements[index] : 0;
    }

    public int size() {
        return this.elements.length;
    }

    @NotNull
    public Version truncate(int n) {
        int m;
        if (this.elements.length <= n) {
            Version version = this;
            if (version == null) {
                Version.$$$reportNull$$$0(4);
            }
            return version;
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative desired size: " + n);
        }
        for (m = n; m > 0 && this.elements[m - 1] == 0; --m) {
        }
        if (m == 0) {
            Version version = ZERO;
            if (version == null) {
                Version.$$$reportNull$$$0(5);
            }
            return version;
        }
        int[] newElements = Arrays.copyOf(this.elements, m);
        return new Version(newElements);
    }

    @NotNull
    public Version truncateNegatives() {
        int n = this.elements.length;
        for (int k = 0; k < n; ++k) {
            if (this.elements[k] >= 0) continue;
            Version version = this.truncate(k);
            if (version == null) {
                Version.$$$reportNull$$$0(6);
            }
            return version;
        }
        Version version = this;
        if (version == null) {
            Version.$$$reportNull$$$0(7);
        }
        return version;
    }

    @Override
    public int compareTo(@NotNull Version that) {
        if (that == null) {
            Version.$$$reportNull$$$0(8);
        }
        if (this == that) {
            return 0;
        }
        int m = Math.max(this.size(), that.size());
        for (int i = 0; i < m; ++i) {
            int z = Version.compare(this.get(i), that.get(i));
            if (z == 0) continue;
            return z;
        }
        return 0;
    }

    @Override
    public int compareTo(int ... that) {
        int m = Math.max(this.size(), that.length);
        for (int i = 0; i < m; ++i) {
            int z = Version.compare(this.get(i), i < that.length ? that[i] : 0);
            if (z == 0) continue;
            return z;
        }
        return 0;
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x > y ? 1 : 0);
    }

    public boolean isOrGreater(int ... than) {
        return this.compareTo(than) >= 0;
    }

    public boolean isOrGreater(@NotNull Version than) {
        if (than == null) {
            Version.$$$reportNull$$$0(9);
        }
        return this.compareTo(than) >= 0;
    }

    public boolean less(int ... than) {
        return this.compareTo(than) < 0;
    }

    public boolean less(@NotNull Version than) {
        if (than == null) {
            Version.$$$reportNull$$$0(10);
        }
        return this.compareTo(than) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        return Arrays.equals(this.elements, that.elements);
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    @NotNull
    public String toString() {
        String string = this.toString(2, 100);
        if (string == null) {
            Version.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String toString(int minimumElements, int maximumElements) {
        int n = Math.min(Math.max(this.elements.length, minimumElements), maximumElements);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                b.append('.');
            }
            b.append(this.get(i));
        }
        String string = b.toString();
        if (string == null) {
            Version.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public int[] toArray() {
        int n = this.elements.length;
        int[] result = Arrays.copyOf(this.elements, n);
        if (result == null) {
            Version.$$$reportNull$$$0(13);
        }
        return result;
    }

    static {
        SPECIAL_VALUES.put("alpha", -30);
        SPECIAL_VALUES.put("beta", -20);
        SPECIAL_VALUES.put("rc", -10);
        ZERO = new Version(new int[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/util/Version";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "than";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/util/Version";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "truncate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateNegatives";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isOrGreater";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "less";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

