/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.DriverManager;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class RemoteLogHelper {
    public static void setDriverManagerLogLevel(Level level) {
        RemoteLogHelper.setLogLevel("DriverManager.LogWriter", level);
    }

    public static void setLogLevel(String name, Level level) {
        JdbcNativeUtil.logInfo(name + ".level=" + level);
        Logger.getLogger(name).setLevel(level);
    }

    public static void loadConfig(String config) throws IOException {
        LogManager manager = LogManager.getLogManager();
        manager.reset();
        if (config != null) {
            manager.readConfiguration(new ByteArrayInputStream(config.getBytes(Charset.defaultCharset())));
            RemoteLogHelper.setDriverManagerLogWriter(new ParseLogWriter());
        }
    }

    public static void setDriverManagerLogWriter(LogWriter out) {
        DriverManager.setLogWriter(new PrintWriter(out));
    }

    private static class ParseLogWriter
    extends LogWriter {
        private final Pattern myPattern = Pattern.compile(".*?\\s(ERROR|WARN|TRACE|INFO|FUNCTION|DEBUG)\\s.*?\\s([^ :.(]+?\\.[^ :(]+?(?:\\([^()]*\\))?):\\s(.*)", 32);

        private ParseLogWriter() {
        }

        @Override
        protected void toLog(String msg) {
            Matcher matcher = this.myPattern.matcher(msg);
            if (matcher.matches()) {
                String lvl = matcher.group(1);
                String fqName = matcher.group(2);
                String rest = matcher.group(3);
                Level msgLvl = lvl.equals("ERROR") ? Level.SEVERE : (lvl.equals("WARN") ? Level.WARNING : (lvl.equals("INFO") ? Level.INFO : (lvl.equals("FUNCTION") ? Level.FINE : (lvl.equals("DEBUG") ? Level.FINER : (lvl.equals("TRACE") ? Level.FINEST : Level.WARNING)))));
                int lastDot = fqName.lastIndexOf(46);
                log.logp(msgLvl, lastDot == -1 ? null : fqName.substring(0, lastDot), lastDot == -1 ? fqName : fqName.substring(lastDot + 1), rest);
            } else {
                super.toLog(msg);
            }
        }
    }

    public static class LogWriter
    extends Writer {
        protected static final Logger log = Logger.getLogger("DriverManager.LogWriter");
        private final StringBuilder buf = new StringBuilder();

        public static LogWriter getInstance() {
            return new LogWriter();
        }

        @Override
        public void write(@NotNull char[] cbuf, int off, int len) {
            if (cbuf == null) {
                LogWriter.$$$reportNull$$$0(0);
            }
            this.buf.append(cbuf, off, len);
        }

        @Override
        public void flush() {
            if (this.buf.length() == 0) {
                return;
            }
            this.toLog(this.buf.toString());
            this.buf.setLength(0);
        }

        protected void toLog(String msg) {
            log.warning(msg);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cbuf", "com/intellij/database/remote/jdbc/helpers/RemoteLogHelper$LogWriter", "write"));
        }
    }
}

