/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.fix;

import com.intellij.execution.ExecutionException;
import com.intellij.history.LocalHistory;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterFixAction;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.service.TslintLanguageServiceManager;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class TsLintFileFixAction
extends JSLinterFixAction {
    public TsLintFileFixAction() {
        super(TsLintBundle.messagePointer("tslint.framework.title", new Object[0]), TsLintBundle.messagePointer("tslint.action.fix.all.problem.title", new Object[0]), null);
    }

    protected boolean isFileAccepted(@NotNull Project project, @NotNull VirtualFile file) {
        FileType fileType;
        if (project == null) {
            TsLintFileFixAction.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TsLintFileFixAction.$$$reportNull$$$0(1);
        }
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(fileType = file.getFileType()) || DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType);
    }

    @NotNull
    protected JSLinterConfiguration getConfiguration(@NotNull Project project) {
        if (project == null) {
            TsLintFileFixAction.$$$reportNull$$$0(2);
        }
        TsLintConfiguration tsLintConfiguration = TsLintConfiguration.getInstance(project);
        if (tsLintConfiguration == null) {
            TsLintFileFixAction.$$$reportNull$$$0(3);
        }
        return tsLintConfiguration;
    }

    protected Task createTask(@NotNull Project project, @NotNull Collection<? extends VirtualFile> filesToProcess, @NotNull Runnable completeCallback, boolean modalProgress) {
        if (project == null) {
            TsLintFileFixAction.$$$reportNull$$$0(4);
        }
        if (filesToProcess == null) {
            TsLintFileFixAction.$$$reportNull$$$0(5);
        }
        if (completeCallback == null) {
            TsLintFileFixAction.$$$reportNull$$$0(6);
        }
        LocalHistory.getInstance().putSystemLabel(project, JavaScriptBundle.message((String)"javascript.linter.action.fix.problems.name.start", (Object[])new Object[]{TsLintBundle.message("tslint.framework.title", new Object[0])}));
        final Consumer task = indicator -> {
            TslintLanguageServiceManager languageServiceManager = TslintLanguageServiceManager.getInstance(project);
            TsLintState state = (TsLintState)TsLintConfiguration.getInstance(project).getExtendedState().getState();
            for (VirtualFile file : filesToProcess) {
                indicator.setText(TsLintBundle.message("tslint.progress.text.processing.file", file.getCanonicalPath()));
                languageServiceManager.useService(file, state.getNodePackageRef(), service -> {
                    if (service == null) {
                        return null;
                    }
                    Future future = (Future)ReadAction.compute(() -> service.highlightAndFix(file, state));
                    try {
                        JSLanguageServiceUtil.awaitLanguageService((Future)future, (LinterLanguageServiceClient)service, (VirtualFile)file);
                    }
                    catch (ExecutionException e) {
                        JSLinterGuesser.NOTIFICATION_GROUP.createNotification(TsLintBundle.message("tslint.notification.content", e.getMessage()), MessageType.ERROR).notify(project);
                    }
                    return null;
                });
            }
            completeCallback.run();
        };
        if (modalProgress) {
            return new Task.Modal(project, TsLintBundle.message("tslint.action.modal.title", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    task.consume((Object)indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction$1", "run"));
                }
            };
        }
        return new Task.Backgroundable(project, TsLintBundle.message("tslint.action.background.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                task.consume((Object)indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction$2", "run"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileAccepted";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

