/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.diagnostics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.diagnostics.CdIndenter;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"collectOCWorkspace", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.diagnostics"})
public final class CdOCWorkspaceKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String collectOCWorkspace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"OCWorkspace.getInstance(project)");
        OCWorkspace ocWorkspace2 = oCWorkspace;
        CdIndenter log = new CdIndenter(0, 1, null);
        List list = ocWorkspace2.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ocWorkspace.configurations");
        List configurations = list;
        log.put("Resolve configurations: ", configurations.size());
        CdIndenter this_$iv = log;
        boolean $i$f$scope = false;
        this_$iv.indent();
        try {
            boolean bl = false;
            Iterator iterator = configurations.iterator();
            while (iterator.hasNext()) {
                Collection sources;
                OCResolveConfiguration config;
                OCResolveConfiguration oCResolveConfiguration = config = (OCResolveConfiguration)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)oCResolveConfiguration, (String)"config");
                Intrinsics.checkNotNullExpressionValue((Object)oCResolveConfiguration.getSources(), (String)"config.sources");
                log.put("Configuration: " + config.getDisplayName() + " (" + config.getName() + ": " + config.getVariant() + "), " + sources.size() + " source file(s)");
                for (VirtualFile source : sources) {
                    CdIndenter this_$iv2 = log;
                    boolean $i$f$scope2 = false;
                    this_$iv2.indent();
                    try {
                        boolean bl2 = false;
                        OCLanguageKind kind = config.getDeclaredLanguageKind(source);
                        Object[] objectArray = new Object[3];
                        objectArray[0] = source;
                        objectArray[1] = " ";
                        StringBuilder stringBuilder = new StringBuilder().append('[');
                        Object object = kind;
                        if (object == null) {
                            object = "UNKNOWN";
                        }
                        objectArray[2] = stringBuilder.append(object).append(']').toString();
                        log.put(objectArray);
                        if (kind == null) continue;
                        CdIndenter this_$iv3 = log;
                        boolean $i$f$scope3 = false;
                        this_$iv3.indent();
                        try {
                            OCCompilerSettings settings;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)config.getCompilerSettings(kind, source), (String)"config.getCompilerSettings(kind, source)");
                            Object object2 = settings.getCompilerExecutable();
                            if (object2 == null || (object2 = ((File)object2).getAbsolutePath()) == null) {
                                object2 = "UNKNOWN";
                            }
                            Object compilerPath = object2;
                            log.put(compilerPath, " ", settings.getCompilerSwitches());
                        }
                        finally {
                            this_$iv3.unIndent();
                        }
                    }
                    finally {
                        this_$iv2.unIndent();
                    }
                }
            }
        }
        finally {
            this_$iv.unIndent();
        }
        return log.getResult();
    }
}

