/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.diagnostics;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.cpp.diagnostics.CdDateUtilKt;
import com.jetbrains.cidr.cpp.diagnostics.CppDiagnosticsBundle;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/cpp/diagnostics/CdWorkspaceEvents;", "", "()V", "events", "", "", "isEnabled", "", "getResult", "selectedResolveConfigurationChanged", "", "workspaceChanged", "event", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceListener$OCWorkspaceEvent;", "Companion", "intellij.clion.diagnostics"})
public final class CdWorkspaceEvents {
    private final List<String> events;
    private final boolean isEnabled;
    private static final String ENABLED_KEY = "cpp.diagnostics.track.events";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled) {
            return;
        }
        this.events.add(CdDateUtilKt.formatCurrentTimeMS() + ": " + event);
    }

    public final void selectedResolveConfigurationChanged() {
        if (!this.isEnabled) {
            return;
        }
        this.events.add(CdDateUtilKt.formatCurrentTimeMS() + ": selectedResolveConfigurationChanged");
    }

    @NotNull
    public final String getResult() {
        if (this.isEnabled) {
            return CollectionsKt.joinToString$default((Iterable)this.events, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
        return CppDiagnosticsBundle.message("cpp.diagnostics.was.not.logged.0", ENABLED_KEY);
    }

    public CdWorkspaceEvents() {
        boolean bl = false;
        this.events = new ArrayList();
        this.isEnabled = Registry.get((String)ENABLED_KEY).asBoolean();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/cpp/diagnostics/CdWorkspaceEvents$Companion;", "", "()V", "ENABLED_KEY", "", "intellij.clion.diagnostics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

