/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.css.CssBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssDialect {
    public static final ExtensionPointName<CssDialect> EP_NAME = ExtensionPointName.create((String)"com.intellij.css.dialect");
    public static final CssDialect CLASSIC = new CssDialect(){

        @Override
        @NotNull
        public String getName() {
            return "CLASSIC";
        }

        @Override
        @NotNull
        @NlsContexts.Label
        public String getDisplayName() {
            String string = CssBundle.message("css.w3c.dialect.name", new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isDefault(@NotNull Module module) {
            if (module == null) {
                1.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/css/CssDialect$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/css/CssDialect$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isDefault";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public abstract String getName();

    @NotNull
    @NlsContexts.Label
    public abstract String getDisplayName();

    public abstract boolean isDefault(@NotNull Module var1);

    @Contract(value="null -> null")
    @Nullable
    public static CssDialect getDefaultDialect(@Nullable Module module) {
        if (module != null) {
            for (CssDialect dialect : EP_NAME.getExtensionList()) {
                if (!dialect.isDefault(module)) continue;
                return dialect;
            }
        }
        return null;
    }

    @NotNull
    public static List<CssDialect> getAvailableDialects() {
        ArrayList<CssDialect> results = new ArrayList<CssDialect>(EP_NAME.getExtensionList());
        results.add(CLASSIC);
        ArrayList<CssDialect> arrayList = results;
        if (arrayList == null) {
            CssDialect.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public static List<CssDialect> getCustomDialects() {
        return new ArrayList<CssDialect>(EP_NAME.getExtensionList());
    }

    @NotNull
    public static CssDialect getDialectByName(@NotNull String dialectName) {
        if (dialectName == null) {
            CssDialect.$$$reportNull$$$0(1);
        }
        if (CLASSIC.getName().equals(dialectName)) {
            CssDialect cssDialect = CLASSIC;
            if (cssDialect == null) {
                CssDialect.$$$reportNull$$$0(2);
            }
            return cssDialect;
        }
        CssDialect dialect = (CssDialect)EP_NAME.getByKey((Object)dialectName, CssDialect.class, d -> d.getName());
        CssDialect cssDialect = dialect != null ? dialect : CLASSIC;
        if (cssDialect == null) {
            CssDialect.$$$reportNull$$$0(3);
        }
        return cssDialect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/CssDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDialects";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/CssDialect";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDialectByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

