/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.xml;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.lang.Language;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTextExtractor
extends TextExtractor {
    private static final TextContentBuilder builder = TextContentBuilder.FromPsi.removingIndents(" \t");
    private final Set<Class<? extends Language>> myEnabledDialects;
    private static final Set<String> NON_TEXT_TAGS = Set.of("code", "pre");

    protected XmlTextExtractor(Class<? extends Language> ... enabledDialects) {
        this.myEnabledDialects = Set.of(enabledDialects);
    }

    @Override
    @Nullable
    protected TextContent buildTextContent(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (element == null) {
            XmlTextExtractor.$$$reportNull$$$0(0);
        }
        if (allowedDomains == null) {
            XmlTextExtractor.$$$reportNull$$$0(1);
        }
        if (element instanceof XmlText && !XmlTextExtractor.isNonText(((XmlText)element).getParentTag()) && this.hasSuitableDialect(element)) {
            return XmlTextExtractor.markEdgesUnknown(builder.excluding(e -> PsiUtilCore.getElementType((PsiElement)e) == XmlElementType.XML_CDATA).build(element, TextContent.TextDomain.PLAIN_TEXT));
        }
        IElementType type = PsiUtilCore.getElementType((PsiElement)element);
        if (type == XmlTokenType.XML_DATA_CHARACTERS && PsiUtilCore.getElementType((PsiElement)element.getParent()) == XmlElementType.XML_CDATA && this.hasSuitableDialect(element)) {
            return XmlTextExtractor.markEdgesUnknown(builder.build(element, TextContent.TextDomain.PLAIN_TEXT));
        }
        if (type == XmlTokenType.XML_COMMENT_CHARACTERS && allowedDomains.contains((Object)TextContent.TextDomain.COMMENTS) && this.hasSuitableDialect(element)) {
            return builder.build(element, TextContent.TextDomain.COMMENTS);
        }
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && allowedDomains.contains((Object)TextContent.TextDomain.LITERALS) && this.hasSuitableDialect(element)) {
            return builder.build(element, TextContent.TextDomain.LITERALS);
        }
        return null;
    }

    private boolean hasSuitableDialect(@NotNull PsiElement element) {
        if (element == null) {
            XmlTextExtractor.$$$reportNull$$$0(2);
        }
        return this.myEnabledDialects.contains(element.getContainingFile().getLanguage().getClass());
    }

    private static boolean isNonText(XmlTag tag) {
        return tag instanceof HtmlTag && NON_TEXT_TAGS.contains(tag.getName());
    }

    private static TextContent markEdgesUnknown(@Nullable TextContent content2) {
        return content2 == null ? null : content2.markUnknown(TextRange.from((int)0, (int)0)).markUnknown(TextRange.from((int)content2.length(), (int)0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedDomains";
                break;
            }
        }
        objectArray2[1] = "com/intellij/grazie/ide/language/xml/XmlTextExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTextContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuitableDialect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Html
    extends XmlTextExtractor {
        public Html() {
            super(HTMLLanguage.class);
        }
    }

    public static class Xml
    extends XmlTextExtractor {
        public Xml() {
            super(XMLLanguage.class, XHTMLLanguage.class, DTDLanguage.class);
        }
    }
}

