/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.TestLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.xml.DOMConfigurator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public final class TestLoggerFactory
implements Logger.Factory {
    private static final String SYSTEM_MACRO = "$SYSTEM_DIR$";
    private static final String APPLICATION_MACRO = "$APPLICATION_DIR$";
    private static final String LOG_DIR_MACRO = "$LOG_DIR$";
    private static final String LOG_DIR = "testlog";
    private static final long LOG_SIZE_LIMIT = 0x6400000L;
    private static final long LOG_SEEK_WINDOW = 102400L;
    private boolean myInitialized;
    private static final char FAILED_TEST_DEBUG_OUTPUT_MARKER = '\u2003';
    private static final StringBuilder BUFFER = new StringBuilder();
    private static final int MAX_BUFFER_LENGTH = 10000000;

    private TestLoggerFactory() {
    }

    @NotNull
    public synchronized Logger getLoggerInstance(@NotNull String category) {
        if (category == null) {
            TestLoggerFactory.$$$reportNull$$$0(0);
        }
        if (!this.myInitialized && TestLoggerFactory.reconfigure()) {
            this.myInitialized = true;
        }
        return new TestLogger(category);
    }

    public static boolean reconfigure() {
        try {
            Path logXmlFile = Paths.get(PathManager.getHomePath(), "test-log.xml");
            if (!Files.exists(logXmlFile, new LinkOption[0])) {
                return false;
            }
            String logDir = TestLoggerFactory.getTestLogDir();
            String text = Files.readString(logXmlFile);
            text = StringUtil.replace((String)text, (String)SYSTEM_MACRO, (String)StringUtil.replace((String)PathManager.getSystemPath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)APPLICATION_MACRO, (String)StringUtil.replace((String)PathManager.getHomePath(), (String)"\\", (String)"\\\\"));
            text = StringUtil.replace((String)text, (String)LOG_DIR_MACRO, (String)StringUtil.replace((String)logDir, (String)"\\", (String)"\\\\"));
            Files.createDirectories(Paths.get(logDir, new String[0]), new FileAttribute[0]);
            System.setProperty("log4j.defaultInitOverride", "true");
            new DOMConfigurator().doConfigure((Reader)new StringReader(text), LogManager.getLoggerRepository());
            Path logFile = Paths.get(TestLoggerFactory.getTestLogDir(), "idea.log");
            if (Files.exists(logFile, new LinkOption[0]) && Files.size(logFile) >= 0x6400000L) {
                Files.writeString(logFile, (CharSequence)"", new OpenOption[0]);
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getTestLogDir() {
        String property = System.getProperty("idea.log.path");
        return property != null ? property : PathManager.getSystemPath() + "/testlog";
    }

    public static void dumpLogToStdout(@NotNull String testStartMarker) {
        Path logFile;
        if (testStartMarker == null) {
            TestLoggerFactory.$$$reportNull$$$0(1);
        }
        if (Files.exists(logFile = Paths.get(TestLoggerFactory.getTestLogDir(), "idea.log"), new LinkOption[0])) {
            try {
                String logText;
                long length = Files.size(logFile);
                if (length > 102400L) {
                    try (RandomAccessFile file2 = new RandomAccessFile(logFile.toFile(), "r");){
                        file2.seek(length - 102400L);
                        byte[] bytes = new byte[102400];
                        int read = file2.read(bytes);
                        logText = new String(bytes, 0, read, StandardCharsets.UTF_8);
                    }
                } else {
                    logText = Files.readString(logFile);
                }
                System.out.println("\n\nIdea Log:");
                Pattern logStart = Pattern.compile("[0-9\\-, :\\[\\]]+(DEBUG|INFO|ERROR) - ");
                for (String line : StringUtil.splitByLines((String)logText.substring(Math.max(0, logText.lastIndexOf(testStartMarker))))) {
                    Matcher matcher = logStart.matcher(line);
                    int lineStart = matcher.lookingAt() ? matcher.end() : 0;
                    System.out.println(line.substring(lineStart));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void enableDebugLogging(@NotNull Disposable parentDisposable, String ... categories) {
        if (parentDisposable == null) {
            TestLoggerFactory.$$$reportNull$$$0(2);
        }
        if (categories == null) {
            TestLoggerFactory.$$$reportNull$$$0(3);
        }
        for (String category : categories) {
            Logger logger = Logger.getInstance((String)category);
            if (logger.isDebugEnabled()) continue;
            logger.setLevel(Level.DEBUG);
            Disposer.register((Disposable)parentDisposable, () -> logger.setLevel(Level.INFO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void log(@NotNull String level, @NotNull String category, @Nullable String message, @Nullable Throwable t) {
        if (level == null) {
            TestLoggerFactory.$$$reportNull$$$0(4);
        }
        if (category == null) {
            TestLoggerFactory.$$$reportNull$$$0(5);
        }
        StringWriter writer = new StringWriter(t == null ? 256 : 4096);
        String source = category.substring(Math.max(category.length() - 30, 0));
        writer.write(String.format("%1$tH:%1$tM:%1$tS,%1$tL %2$-5s %3$30s - ", System.currentTimeMillis(), level, source));
        writer.write(message != null ? message : "");
        writer.write(System.lineSeparator());
        if (t != null) {
            t.printStackTrace(new PrintWriter(writer));
            writer.write(System.lineSeparator());
        }
        StringBuilder stringBuilder = BUFFER;
        synchronized (stringBuilder) {
            BUFFER.append(writer.getBuffer());
            if (BUFFER.length() > 10000000) {
                BUFFER.delete(0, BUFFER.length() - 10000000 + 2500000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onTestStarted() {
        StringBuilder stringBuilder = BUFFER;
        synchronized (stringBuilder) {
            BUFFER.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onTestFinished(boolean success) {
        String buffer;
        StringBuilder stringBuilder = BUFFER;
        synchronized (stringBuilder) {
            buffer = BUFFER.length() != 0 && !success ? BUFFER.toString() : null;
            BUFFER.setLength(0);
        }
        if (buffer != null) {
            if (System.getenv("TEAMCITY_VERSION") != null) {
                System.out.flush();
                System.out.println("##teamcity[blockOpened name='DEBUG log']");
                System.out.flush();
                System.out.println(buffer);
                System.out.flush();
                System.out.println("##teamcity[blockClosed name='DEBUG log']");
                System.out.flush();
            } else {
                List lines = LineTokenizer.tokenizeIntoList((CharSequence)buffer, (boolean)false, (boolean)false);
                if (!((String)lines.get(0)).startsWith("\n")) {
                    lines.set(0, "\n" + (String)lines.get(0));
                }
                System.err.println(String.join((CharSequence)"\u2003\n", lines));
            }
        }
    }

    @NotNull
    public static TestRule createTestWatcher() {
        return new TestWatcher(){

            protected void succeeded(Description description) {
                TestLoggerFactory.onTestFinished(true);
            }

            protected void failed(Throwable e, Description description) {
                TestLoggerFactory.onTestFinished(false);
            }

            protected void skipped(AssumptionViolatedException e, Description description) {
                TestLoggerFactory.onTestFinished(true);
            }

            protected void starting(@NotNull Description d) {
                if (d == null) {
                    1.$$$reportNull$$$0(0);
                }
                TestLoggerFactory.onTestStarted();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/intellij/testFramework/TestLoggerFactory$1", "starting"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testStartMarker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestLoggerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLoggerInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpLogToStdout";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "enableDebugLogging";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "log";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

