/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.CLSAbstractFileEntry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.MockClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFile;
import java.net.URISyntaxException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class CLSTestUtils {
    public static void addFiles(@NotNull ClangLocalWorkspace localWs, @NotNull ClangRemoteWorkspace remoteWs, CLSAbstractFileEntry ... entries) {
        if (localWs == null) {
            CLSTestUtils.$$$reportNull$$$0(0);
        }
        if (remoteWs == null) {
            CLSTestUtils.$$$reportNull$$$0(1);
        }
        for (CLSAbstractFileEntry entry : entries) {
            localWs.modifyWithRead(entry.virtualFile.getUrl(), lwf -> {
                entry.applyToLocal((LocalWorkspaceFile)lwf);
                if (entry.finished) {
                    remoteWs.modify(lwf.getUrl(), rwf -> entry.applyToRemote((LocalWorkspaceFile)lwf, (RemoteWorkspaceFile)rwf));
                }
            });
        }
    }

    @NotNull
    public static MockClangIdeFacade addFiles(@NotNull ClangUrlConverter converter, @NotNull MockClangIdeFacade facade, CLSAbstractFileEntry ... entries) {
        if (converter == null) {
            CLSTestUtils.$$$reportNull$$$0(2);
        }
        if (facade == null) {
            CLSTestUtils.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < entries.length; ++i) {
            CLSAbstractFileEntry entry = entries[i];
            facade.addOrReplace(new MockClangIdeFacade.FileEntry(entry.virtualFile, "blabla" + i, entry.modified, CLSTestUtils.createDummyCompilationCommand(converter.toUri(entry.virtualFile.getPath()), i), "bla" + i, null));
        }
        MockClangIdeFacade mockClangIdeFacade = facade;
        if (mockClangIdeFacade == null) {
            CLSTestUtils.$$$reportNull$$$0(4);
        }
        return mockClangIdeFacade;
    }

    public static int howManyMacrosFiles(@NotNull ClangDaemonContext context) throws URISyntaxException {
        if (context == null) {
            CLSTestUtils.$$$reportNull$$$0(5);
        }
        int counter = 0;
        for (String url : context.getLocalWorkspace().getRegisteredUrls()) {
            if (!ClangRequestsHelper.isMacroFile((ClangUrlConverter)context.getUrlConverter(), (String)url)) continue;
            ++counter;
        }
        return counter;
    }

    @NotNull
    private static ClionCompileCommandParams createDummyCompilationCommand(@NotNull String uri, int index) {
        if (uri == null) {
            CLSTestUtils.$$$reportNull$$$0(6);
        }
        return new ClionCompileCommandParams(uri, uri, "bla" + index, Collections.emptyList(), "/dev/null");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localWs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteWs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/CLSTestUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/CLSTestUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "howManyMacrosFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDummyCompilationCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

