/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.makefile.MakefileFile;
import com.jetbrains.lang.makefile.MakefileRunConfiguration;
import com.jetbrains.lang.makefile.MakefileRunConfigurationType;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/lang/makefile/MakefileRunConfigurationFactory;", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "runConfigurationType", "Lcom/jetbrains/lang/makefile/MakefileRunConfigurationType;", "(Lcom/jetbrains/lang/makefile/MakefileRunConfigurationType;)V", "createConfigurationFromTarget", "Lcom/jetbrains/lang/makefile/MakefileRunConfiguration;", "target", "Lcom/jetbrains/lang/makefile/psi/MakefileTarget;", "createTemplateConfiguration", "project", "Lcom/intellij/openapi/project/Project;", "getId", "", "getName", "intellij.makefile"})
public final class MakefileRunConfigurationFactory
extends ConfigurationFactory {
    private final MakefileRunConfigurationType runConfigurationType;

    @NotNull
    public String getId() {
        return "Makefile";
    }

    @NotNull
    public String getName() {
        return this.runConfigurationType.getDisplayName();
    }

    @NotNull
    public MakefileRunConfiguration createTemplateConfiguration(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new MakefileRunConfiguration(project, this, "name");
    }

    @Nullable
    public final MakefileRunConfiguration createConfigurationFromTarget(@NotNull MakefileTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"target.project");
        String string = target.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target.name");
        MakefileRunConfiguration configuration = new MakefileRunConfiguration(project, this, string);
        PsiFile psiFile = target.getContainingFile();
        if (!(psiFile instanceof MakefileFile)) {
            psiFile = null;
        }
        MakefileFile makefileFile = (MakefileFile)psiFile;
        if (makefileFile == null) {
            return null;
        }
        MakefileFile file = makefileFile;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)target.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"PathMacroManager.getInstance(target.project)");
        PathMacroManager macroManager = pathMacroManager;
        Object object = file.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.virtualFile?.path ?: return null");
        Object path = object;
        String string2 = macroManager.collapsePath((String)path);
        if (string2 == null) {
            string2 = "";
        }
        configuration.setFilename(string2);
        String string3 = target.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"target.name");
        configuration.setTarget(string3);
        CharSequence charSequence = configuration.getTarget();
        boolean bl = false;
        if (charSequence.length() > 0) {
            configuration.setName(configuration.getTarget());
        } else {
            configuration.setName(new File((String)path).getName());
        }
        return configuration;
    }

    public MakefileRunConfigurationFactory(@NotNull MakefileRunConfigurationType runConfigurationType) {
        Intrinsics.checkNotNullParameter((Object)runConfigurationType, (String)"runConfigurationType");
        super((ConfigurationType)runConfigurationType);
        this.runConfigurationType = runConfigurationType;
    }
}

