/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;

public final class StringUtils {
    private static final char[] SHIFTS = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', 'r', 'x', '5', 'O', '`', 'm', 'H', 'l', 'F', '@', 'L', 'C', 't', 'J', 'D', 'W', 'o', '4', 'K', 'w', '1', '\"', 'R', 'Q', '_', 'A', 'p', 'V', 'v', 'n', 'z', 'i', ')', '9', 'S', '+', '.', 'f', '(', 'Y', '&', 'g', '-', '2', '*', '{', '[', '#', '}', '7', '6', 'B', '|', '~', ';', '/', '\\', 'G', 's', 'N', 'X', 'k', 'j', '8', '$', 'y', 'u', 'h', 'e', 'd', 'E', 'I', 'c', '?', '^', ']', '\'', '%', '=', '0', ':', 'q', ' ', 'Z', ',', 'b', '<', '3', '!', 'a', '>', 'M', 'T', 'P', 'U', '\u00df', '\u00e1', '\u00d8', '\u00bb', '\u00a6', '\u00e5', '\u00bd', '\u00de', '\u00bc', '\u008d', '\u00f9', '\u0094', '\u00c8', '\u00b8', '\u0088', '\u00f8', '\u00be', '\u00c7', '\u00aa', '\u00b5', '\u00cc', '\u008a', '\u00e8', '\u00da', '\u00b7', '\u00ff', '\u00ea', '\u00dc', '\u00f7', '\u00d5', '\u00cb', '\u00e2', '\u00c1', '\u00ae', '\u00ac', '\u00e4', '\u00fc', '\u00d9', '\u00c9', '\u0083', '\u00e6', '\u00c5', '\u00d3', '\u0091', '\u00ee', '\u00a1', '\u00b3', '\u00a0', '\u00d4', '\u00cf', '\u00dd', '\u00fe', '\u00ad', '\u00ca', '\u0092', '\u00e0', '\u0097', '\u008c', '\u00c4', '\u00cd', '\u0082', '\u0087', '\u0085', '\u008f', '\u00f6', '\u00c0', '\u009f', '\u00f4', '\u00ef', '\u00b9', '\u00a8', '\u00d7', '\u0090', '\u008b', '\u00a5', '\u00b4', '\u009d', '\u0093', '\u00ba', '\u00d6', '\u00b0', '\u00e3', '\u00e7', '\u00db', '\u00a9', '\u00af', '\u009c', '\u00ce', '\u00c6', '\u0081', '\u00a4', '\u0096', '\u00d2', '\u009a', '\u00b1', '\u0086', '\u007f', '\u00b6', '\u0080', '\u009e', '\u00d0', '\u00a2', '\u0084', '\u00a7', '\u00d1', '\u0095', '\u00f1', '\u0099', '\u00fb', '\u00ed', '\u00ec', '\u00ab', '\u00c3', '\u00f3', '\u00e9', '\u00fd', '\u00f0', '\u00c2', '\u00fa', '\u00bf', '\u009b', '\u008e', '\u0089', '\u00f5', '\u00eb', '\u00a3', '\u00f2', '\u00b2', '\u0098'};

    private StringUtils() {
    }

    public static String uncapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            return string.toLowerCase(Locale.US);
        }
        return string.substring(0, 1).toLowerCase(Locale.US) + string.substring(1);
    }

    public static String getErrorMessage(Throwable t) {
        String errMsg;
        if (t == null) {
            return "";
        }
        if (t instanceof InvocationTargetException) {
            InvocationTargetException ex = (InvocationTargetException)t;
            t = ex.getTargetException();
        }
        String string = errMsg = t instanceof RuntimeException ? t.getMessage() : t.toString();
        if (errMsg == null || errMsg.length() == 0 || "null".equals(errMsg)) {
            errMsg = t.getClass().getName() + " at " + t.getStackTrace()[0].toString();
        }
        return errMsg;
    }

    public static String getStackTrace(Exception e) {
        if (e == null) {
            return "";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(baos);
        e.printStackTrace(printWriter);
        printWriter.flush();
        String stackTrace = new String(baos.toByteArray());
        printWriter.close();
        return stackTrace;
    }

    public static String join(Object[] objs, String sep) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < objs.length; ++i) {
            buf.append(objs[i]).append(sep);
        }
        if (objs.length > 0) {
            buf.setLength(buf.length() - sep.length());
        }
        return buf.toString();
    }

    public static final String encrypt(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= SHIFTS.length) {
                throw new IllegalArgumentException("encrypt method can only be used with simple characters. '" + c + "' not allowed");
            }
            buf.append(SHIFTS[c]);
        }
        return buf.toString();
    }

    public static final String decrypt(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            buf.append(StringUtils.decrypt(str.charAt(i)));
        }
        return buf.toString();
    }

    private static char decrypt(char c) {
        for (char i = '\u0000'; i < SHIFTS.length; i = (char)(i + '\u0001')) {
            if (SHIFTS[i] != c) continue;
            return i;
        }
        throw new IllegalArgumentException("Impossible to decrypt '" + c + "'. Unhandled character.");
    }

    public static String repeat(String str, int count) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }
}

