/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import com.carrotsearch.hppc.ObjectContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;

public class ElectMasterService {
    private static final Logger logger = LogManager.getLogger(ElectMasterService.class);
    public static final Setting<Integer> DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING = Setting.intSetting("discovery.zen.minimum_master_nodes", -1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile int minimumMasterNodes;

    public ElectMasterService(Settings settings) {
        this.minimumMasterNodes = DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.get(settings);
        logger.debug("using minimum_master_nodes [{}]", (Object)this.minimumMasterNodes);
    }

    public void minimumMasterNodes(int minimumMasterNodes) {
        this.minimumMasterNodes = minimumMasterNodes;
    }

    public int minimumMasterNodes() {
        return this.minimumMasterNodes;
    }

    public int countMasterNodes(Iterable<DiscoveryNode> nodes) {
        int count = 0;
        for (DiscoveryNode node : nodes) {
            if (!node.isMasterNode()) continue;
            ++count;
        }
        return count;
    }

    public boolean hasEnoughCandidates(Collection<MasterCandidate> candidates) {
        if (candidates.isEmpty()) {
            return false;
        }
        if (this.minimumMasterNodes < 1) {
            return true;
        }
        assert (candidates.stream().map(MasterCandidate::getNode).collect(Collectors.toSet()).size() == candidates.size()) : "duplicates ahead: " + candidates;
        return candidates.size() >= this.minimumMasterNodes;
    }

    public MasterCandidate electMaster(Collection<MasterCandidate> candidates) {
        assert (this.hasEnoughCandidates(candidates));
        ArrayList<MasterCandidate> sortedCandidates = new ArrayList<MasterCandidate>(candidates);
        sortedCandidates.sort(MasterCandidate::compare);
        return (MasterCandidate)sortedCandidates.get(0);
    }

    public DiscoveryNode tieBreakActiveMasters(Collection<DiscoveryNode> activeMasters) {
        return activeMasters.stream().min(ElectMasterService::compareNodes).get();
    }

    public boolean hasEnoughMasterNodes(Iterable<DiscoveryNode> nodes) {
        int count = this.countMasterNodes(nodes);
        return count > 0 && (this.minimumMasterNodes < 0 || count >= this.minimumMasterNodes);
    }

    public boolean hasTooManyMasterNodes(Iterable<DiscoveryNode> nodes) {
        int count = this.countMasterNodes(nodes);
        return count > 1 && this.minimumMasterNodes <= count / 2;
    }

    public void logMinimumMasterNodesWarningIfNecessary(ClusterState oldState, ClusterState newState) {
        if (!this.hasTooManyMasterNodes(oldState.nodes()) && this.hasTooManyMasterNodes(newState.nodes())) {
            logger.warn("value for setting \"{}\" is too low. This can result in data loss! Please set it to at least a quorum of master-eligible nodes (current value: [{}], total number of master-eligible nodes used for publishing in this round: [{}])", (Object)DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.getKey(), (Object)this.minimumMasterNodes(), (Object)newState.getNodes().getMasterNodes().size());
        }
    }

    static List<DiscoveryNode> sortByMasterLikelihood(Iterable<DiscoveryNode> nodes) {
        ArrayList<DiscoveryNode> sortedNodes = CollectionUtils.iterableAsArrayList(nodes);
        CollectionUtil.introSort(sortedNodes, ElectMasterService::compareNodes);
        return sortedNodes;
    }

    public DiscoveryNode[] nextPossibleMasters(ObjectContainer<DiscoveryNode> nodes, int numberOfPossibleMasters) {
        List<DiscoveryNode> sortedNodes = this.sortedMasterNodes(Arrays.asList((DiscoveryNode[])nodes.toArray(DiscoveryNode.class)));
        if (sortedNodes == null) {
            return new DiscoveryNode[0];
        }
        ArrayList<DiscoveryNode> nextPossibleMasters = new ArrayList<DiscoveryNode>(numberOfPossibleMasters);
        int counter = 0;
        for (DiscoveryNode nextPossibleMaster : sortedNodes) {
            if (++counter >= numberOfPossibleMasters) break;
            nextPossibleMasters.add(nextPossibleMaster);
        }
        return nextPossibleMasters.toArray(new DiscoveryNode[nextPossibleMasters.size()]);
    }

    private List<DiscoveryNode> sortedMasterNodes(Iterable<DiscoveryNode> nodes) {
        ArrayList<DiscoveryNode> possibleNodes = CollectionUtils.iterableAsArrayList(nodes);
        if (possibleNodes.isEmpty()) {
            return null;
        }
        possibleNodes.removeIf(node -> !node.isMasterNode());
        CollectionUtil.introSort(possibleNodes, ElectMasterService::compareNodes);
        return possibleNodes;
    }

    private static int compareNodes(DiscoveryNode o1, DiscoveryNode o2) {
        if (o1.isMasterNode() && !o2.isMasterNode()) {
            return -1;
        }
        if (!o1.isMasterNode() && o2.isMasterNode()) {
            return 1;
        }
        return o1.getId().compareTo(o2.getId());
    }

    public static class MasterCandidate {
        public static final long UNRECOVERED_CLUSTER_VERSION = -1L;
        final DiscoveryNode node;
        final long clusterStateVersion;

        public MasterCandidate(DiscoveryNode node, long clusterStateVersion) {
            Objects.requireNonNull(node);
            assert (clusterStateVersion >= -1L) : "got: " + clusterStateVersion;
            assert (node.isMasterNode());
            this.node = node;
            this.clusterStateVersion = clusterStateVersion;
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public long getClusterStateVersion() {
            return this.clusterStateVersion;
        }

        public String toString() {
            return "Candidate{node=" + this.node + ", clusterStateVersion=" + this.clusterStateVersion + '}';
        }

        public static int compare(MasterCandidate c1, MasterCandidate c2) {
            int ret = Long.compare(c2.clusterStateVersion, c1.clusterStateVersion);
            if (ret == 0) {
                ret = ElectMasterService.compareNodes(c1.getNode(), c2.getNode());
            }
            return ret;
        }
    }
}

