/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;

public class TransportChannelResponseHandler<T extends TransportResponse>
implements TransportResponseHandler<T> {
    private final Logger logger;
    private final TransportChannel channel;
    private final String extraInfoOnError;
    private final Writeable.Reader<T> reader;

    public TransportChannelResponseHandler(Logger logger, TransportChannel channel, String extraInfoOnError, Writeable.Reader<T> reader) {
        this.logger = logger;
        this.channel = channel;
        this.extraInfoOnError = extraInfoOnError;
        this.reader = reader;
    }

    @Override
    public T read(StreamInput in) throws IOException {
        return (T)((TransportResponse)this.reader.read(in));
    }

    @Override
    public void handleResponse(T response) {
        try {
            this.channel.sendResponse((TransportResponse)response);
        }
        catch (IOException e) {
            this.handleException(new TransportException(e));
        }
    }

    @Override
    public void handleException(TransportException exp) {
        try {
            this.channel.sendResponse(exp);
        }
        catch (IOException e) {
            this.logger.debug(() -> new ParameterizedMessage("failed to send failure {}", (Object)(this.extraInfoOnError == null ? "" : "(" + this.extraInfoOnError + ")")), (Throwable)e);
        }
    }

    @Override
    public String executor() {
        return "same";
    }
}

