/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.DateUtils;
import org.joda.time.DateTime;

public class FieldHitExtractor
implements HitExtractor {
    static final String NAME = "f";
    private final String fieldName;
    private final String hitName;
    private final DataType dataType;
    private final ZoneId zoneId;
    private final boolean useDocValue;
    private final boolean arrayLeniency;
    private final String[] path;

    private static String[] sourcePath(String name, boolean useDocValue, String hitName) {
        return useDocValue ? Strings.EMPTY_ARRAY : Strings.tokenizeToStringArray((String)(hitName == null ? name : name.substring(hitName.length() + 1)), (String)".");
    }

    public FieldHitExtractor(String name, DataType dataType, ZoneId zoneId, boolean useDocValue) {
        this(name, dataType, zoneId, useDocValue, null, false);
    }

    public FieldHitExtractor(String name, DataType dataType, ZoneId zoneId, boolean useDocValue, boolean arrayLeniency) {
        this(name, dataType, zoneId, useDocValue, null, arrayLeniency);
    }

    public FieldHitExtractor(String name, DataType dataType, ZoneId zoneId, boolean useDocValue, String hitName, boolean arrayLeniency) {
        this.fieldName = name;
        this.dataType = dataType;
        this.zoneId = zoneId;
        this.useDocValue = useDocValue;
        this.arrayLeniency = arrayLeniency;
        this.hitName = hitName;
        if (hitName != null && !name.contains(hitName)) {
            throw new SqlIllegalArgumentException("Hitname [{}] specified but not part of the name [{}]", hitName, name);
        }
        this.path = FieldHitExtractor.sourcePath(this.fieldName, useDocValue, hitName);
    }

    FieldHitExtractor(StreamInput in) throws IOException {
        this.fieldName = in.readString();
        String esType = in.readOptionalString();
        this.dataType = esType != null ? DataType.fromTypeName(esType) : null;
        this.zoneId = ZoneId.of(in.readString());
        this.useDocValue = in.readBoolean();
        this.hitName = in.readOptionalString();
        this.arrayLeniency = in.readBoolean();
        this.path = FieldHitExtractor.sourcePath(this.fieldName, this.useDocValue, this.hitName);
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeOptionalString(this.dataType == null ? null : this.dataType.typeName);
        out.writeString(this.zoneId.getId());
        out.writeBoolean(this.useDocValue);
        out.writeOptionalString(this.hitName);
        out.writeBoolean(this.arrayLeniency);
    }

    @Override
    public Object extract(SearchHit hit) {
        Object value = null;
        if (this.useDocValue) {
            DocumentField field = hit.field(this.fieldName);
            if (field != null) {
                value = this.unwrapMultiValue(field.getValues());
            }
        } else {
            Map source = hit.getSourceAsMap();
            if (source != null) {
                value = this.extractFromSource(source);
            }
        }
        return value;
    }

    private Object unwrapMultiValue(Object values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List list = (List)values;
            if (list.isEmpty()) {
                return null;
            }
            if (this.arrayLeniency || list.size() == 1) {
                return this.unwrapMultiValue(list.get(0));
            }
            throw new SqlIllegalArgumentException("Arrays (returned by [{}]) are not supported", this.fieldName);
        }
        if (values instanceof Map) {
            throw new SqlIllegalArgumentException("Objects (returned by [{}]) are not supported", this.fieldName);
        }
        if (this.dataType == DataType.DATETIME) {
            if (values instanceof String) {
                return DateUtils.asDateTime(Long.parseLong(values.toString()), this.zoneId);
            }
            if (values instanceof DateTime) {
                return DateUtils.asDateTime((DateTime)values);
            }
        }
        if (values instanceof Number || values instanceof String || values instanceof Boolean) {
            return values;
        }
        throw new SqlIllegalArgumentException("Type {} (returned by [{}]) is not supported", values.getClass().getSimpleName(), this.fieldName);
    }

    Object extractFromSource(Map<String, Object> map) {
        Object value = null;
        ArrayDeque<Tuple> queue = new ArrayDeque<Tuple>();
        queue.add(new Tuple((Object)-1, map));
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.removeLast();
            int idx = (Integer)tuple.v1();
            Map subMap = (Map)tuple.v2();
            StringJoiner sj = new StringJoiner(".");
            for (int i = idx + 1; i < this.path.length; ++i) {
                sj.add(this.path[i]);
                Object node = subMap.get(sj.toString());
                if (node instanceof List) {
                    List listOfValues = (List)node;
                    if (i < this.path.length - 1 && (listOfValues.size() == 1 || this.arrayLeniency)) {
                        node = listOfValues.get(0);
                    } else {
                        return this.unwrapMultiValue(node);
                    }
                }
                if (node instanceof Map) {
                    if (i < this.path.length - 1) {
                        queue.add(new Tuple((Object)i, (Object)((Map)node)));
                        continue;
                    }
                    value = node;
                    continue;
                }
                if (node == null) continue;
                if (i < this.path.length - 1) {
                    throw new SqlIllegalArgumentException("Cannot extract value [{}] from source", this.fieldName);
                }
                if (value != null) {
                    throw new SqlIllegalArgumentException("Multiple values (returned by [{}]) are not supported", this.fieldName);
                }
                value = node;
            }
        }
        return this.unwrapMultiValue(value);
    }

    @Override
    public String hitName() {
        return this.hitName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    DataType dataType() {
        return this.dataType;
    }

    public String toString() {
        return this.fieldName + "@" + this.hitName + "@" + this.zoneId;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FieldHitExtractor other = (FieldHitExtractor)obj;
        return this.fieldName.equals(other.fieldName) && this.hitName.equals(other.hitName) && this.useDocValue == other.useDocValue && this.arrayLeniency == other.arrayLeniency;
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.useDocValue, this.hitName, this.arrayLeniency);
    }
}

