/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.xpack.sql.type.DataType;

public class EsField {
    private final DataType esDataType;
    private final boolean aggregatable;
    private final Map<String, EsField> properties;
    private final String name;

    public EsField(String name, DataType esDataType, Map<String, EsField> properties, boolean aggregatable) {
        this.name = name;
        this.esDataType = esDataType;
        this.aggregatable = aggregatable;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.esDataType;
    }

    public boolean isAggregatable() {
        return this.aggregatable;
    }

    @Nullable
    public Map<String, EsField> getProperties() {
        return this.properties;
    }

    public EsField getExactField() {
        return this;
    }

    public int getPrecision() {
        return this.esDataType.defaultPrecision;
    }

    public Exact getExactInfo() {
        return Exact.EXACT_FIELD;
    }

    public String toString() {
        return this.name + "@" + this.esDataType.name() + "=" + this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsField field = (EsField)o;
        return this.aggregatable == field.aggregatable && this.esDataType == field.esDataType && Objects.equals(this.name, field.name) && Objects.equals(this.properties, field.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.esDataType, this.aggregatable, this.properties, this.name});
    }

    public static final class Exact {
        private static Exact EXACT_FIELD = new Exact(true, null);
        private boolean hasExact;
        private String errorMsg;

        public Exact(boolean hasExact, String errorMsg) {
            this.hasExact = hasExact;
            this.errorMsg = errorMsg;
        }

        public boolean hasExact() {
            return this.hasExact;
        }

        public String errorMsg() {
            return this.errorMsg;
        }
    }
}

