/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.PluginAwareInternal;
import org.gradle.api.internal.plugins.PluginTarget;
import org.gradle.api.internal.plugins.PluginTargetType;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.internal.Cast;
import org.gradle.internal.deprecation.Documentation;

public class ImperativeOnlyPluginTarget<T extends PluginAwareInternal>
implements PluginTarget {
    private final PluginTargetType targetType;
    private final T target;
    private final InternalProblems problems;

    public ImperativeOnlyPluginTarget(PluginTargetType targetType, T target, InternalProblems problems) {
        this.targetType = targetType;
        this.target = target;
        this.problems = problems;
    }

    @Override
    public ConfigurationTargetIdentifier getConfigurationTargetIdentifier() {
        return this.target.getConfigurationTargetIdentifier();
    }

    @Override
    public void applyImperative(@Nullable String pluginId, Plugin<?> plugin) {
        Plugin cast = (Plugin)Cast.uncheckedCast(plugin);
        try {
            cast.apply(this.target);
        }
        catch (ClassCastException e) {
            this.maybeThrowOnTargetMismatch(plugin);
            throw e;
        }
    }

    private void maybeThrowOnTargetMismatch(Plugin<?> plugin) {
        Type typeParameter = (Type)TypeUtils.getTypeArguments(plugin.getClass(), Plugin.class).get(Plugin.class.getTypeParameters()[0]);
        if (!(typeParameter instanceof Class)) {
            return;
        }
        PluginTargetType actualTargetType = PluginTargetType.from((Class)typeParameter);
        if (actualTargetType == null || this.targetType.equals((Object)actualTargetType)) {
            return;
        }
        throw this.problems.getInternalReporter().throwing(spec -> {
            String message = String.format("The plugin must be applied %s, but was applied %s", actualTargetType.getApplyTargetDescription(), this.targetType.getApplyTargetDescription());
            spec.id("target-type-mismatch", "Unexpected plugin type", GradleCoreProblemGroup.pluginApplication()).severity(Severity.ERROR).withException((RuntimeException)new IllegalArgumentException(message)).contextualLabel(message).documentedAt(Documentation.userManual((String)"custom_plugins", (String)"project_vs_settings_vs_init_plugins").toString());
        });
    }

    @Override
    public void applyRules(@Nullable String pluginId, Class<?> clazz) {
        String message = String.format("Cannot apply model rules of plugin '%s' as the target '%s' is not model rule aware", clazz.getName(), this.target.toString());
        throw new UnsupportedOperationException(message);
    }

    @Override
    public void applyImperativeRulesHybrid(@Nullable String pluginId, Plugin<?> plugin, Class<?> declaringClass) {
        this.applyRules(pluginId, declaringClass);
    }

    public String toString() {
        return this.target.toString();
    }
}

