/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.ui.color.ColorUtilities;

public class PicardAlignment
extends SAMAlignment
implements Alignment {
    private static Logger log = Logger.getLogger(PicardAlignment.class);
    private static IGVPreferences prefMgr = PreferencesManager.getPreferences();
    private static final int READ_PAIRED_FLAG = 1;
    private static final int PROPER_PAIR_FLAG = 2;
    private static final int READ_UNMAPPED_FLAG = 4;
    private static final int MATE_UNMAPPED_FLAG = 8;
    private static final int READ_STRAND_FLAG = 16;
    protected static final int MATE_STRAND_FLAG = 32;
    private static final int FIRST_OF_PAIR_FLAG = 64;
    private static final int SECOND_OF_PAIR_FLAG = 128;
    private static final int NOT_PRIMARY_ALIGNMENT_FLAG = 256;
    private static final int READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
    private static final int DUPLICATE_READ_FLAG = 1024;
    private static final int SUPPLEMENTARY_ALIGNMENT_FLAG = 2048;
    private SAMReadGroupRecord readGroupRecord;
    private int flags;
    private SAMRecord record;

    public PicardAlignment(SAMRecord record) {
        Object colorTag;
        String readGroup;
        this.record = record;
        this.flags = record.getFlags();
        String refName = record.getReferenceName();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        this.chr = genome == null ? refName : genome.getCanonicalChrName(refName);
        this.end = record.getAlignmentEnd();
        this.start = record.getAlignmentStart() - 1;
        if (record.getReadPairedFlag()) {
            String mateReferenceName = record.getMateReferenceName();
            String mateChr = genome == null ? mateReferenceName : genome.getCanonicalChrName(mateReferenceName);
            this.setMate(new ReadMate(mateChr, record.getMateAlignmentStart() - 1, record.getMateNegativeStrandFlag(), record.getMateUnmappedFlag()));
        }
        SAMFileHeader header = record.getHeader();
        String keySequence = null;
        String flowOrder = null;
        if (header != null && (readGroup = (String)record.getAttribute("RG")) != null) {
            this.readGroupRecord = header.getReadGroup(readGroup);
            if (this.readGroupRecord != null) {
                keySequence = this.readGroupRecord.getKeySequence();
                flowOrder = this.readGroupRecord.getFlowOrder();
            }
        }
        if ((colorTag = record.getAttribute("YC")) != null) {
            try {
                this.ycColor = ColorUtilities.stringToColor(colorTag.toString(), null);
            }
            catch (Exception e) {
                log.error((Object)("Error interpreting color tag: " + colorTag), (Throwable)e);
            }
        }
        this.setPairOrientation();
        this.setPairStrands();
        this.createAlignmentBlocks(record.getCigarString(), record.getReadBases(), record.getBaseQualities());
    }

    public SAMRecord getRecord() {
        return this.record;
    }

    @Override
    public Object getAttribute(String key) {
        return key.length() == 2 ? this.record.getAttribute(key) : (key.equals("TEMPLATE_ORIENTATION") ? this.pairOrientation : null);
    }

    @Override
    public boolean isFirstOfPair() {
        return this.isPaired() && (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isSecondOfPair() {
        return this.isPaired() && (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isDuplicate() {
        return (this.flags & 0x400) != 0;
    }

    @Override
    public boolean isMapped() {
        return (this.flags & 4) == 0;
    }

    @Override
    public boolean isPaired() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isProperPair() {
        return (this.flags & 1) != 0 && (this.flags & 2) != 0;
    }

    @Override
    public boolean isNegativeStrand() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isSupplementary() {
        return (this.flags & 0x800) != 0;
    }

    @Override
    public boolean isVendorFailedRead() {
        return (this.flags & 0x200) != 0;
    }

    @Override
    public boolean isPrimary() {
        return (this.flags & 0x100) == 0;
    }

    public String toString() {
        return this.record.getSAMString();
    }

    @Override
    public String getReadName() {
        return this.record.getReadName();
    }

    @Override
    public int getMappingQuality() {
        return this.record.getMappingQuality();
    }

    @Override
    public int getInferredInsertSize() {
        return this.record.getInferredInsertSize();
    }

    @Override
    public String getCigarString() {
        return this.record.getCigarString();
    }

    @Override
    public String getReadLengthString() {
        String rs = this.record.getReadString();
        if (rs.equals("*") || rs.equals("")) {
            return "undefined";
        }
        return Globals.DECIMAL_FORMAT.format(rs.length()) + "bp";
    }

    @Override
    public String getReadSequence() {
        return this.record.getReadString();
    }

    @Override
    public int getAlignmentStart() {
        return this.record.getAlignmentStart() - 1;
    }

    @Override
    public int getAlignmentEnd() {
        return this.record.getAlignmentEnd();
    }

    @Override
    protected String getAttributeString(boolean truncate) {
        ArrayList<String> tagsToHide = new ArrayList<String>();
        ArrayList<String> tagsHidden = new ArrayList<String>();
        String samHiddenTagsPref = prefMgr.get("SAM.HIDDEN_TAGS");
        for (String s : (samHiddenTagsPref == null ? "" : samHiddenTagsPref).split("[, ]")) {
            if (s.equals("")) continue;
            tagsToHide.add(s);
        }
        StringBuffer buf = new StringBuffer();
        SAMRecord record = this.getRecord();
        List attributes = record.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            for (SAMRecord.SAMTagAndValue tag : attributes) {
                if (tagsToHide.contains(tag.tag)) {
                    tagsHidden.add(tag.tag);
                    continue;
                }
                buf.append("<br>" + tag.tag + " = ");
                if (tag.value.getClass().isArray()) {
                    buf.append("[not shown]<br>");
                    continue;
                }
                String tagValue = tag.value.toString();
                int maxLength = 70;
                if (tagValue.length() > 70 && truncate) {
                    String[] tokens;
                    for (String token : tokens = tagValue.split("<br>")) {
                        if (token.length() > 70) {
                            String remainder = token;
                            while (remainder.length() > 70) {
                                String tmp = remainder.substring(0, 70);
                                int spaceIndex = tmp.lastIndexOf(32);
                                int idx = spaceIndex > 30 ? spaceIndex : 70;
                                String substring = remainder.substring(0, idx);
                                buf.append(substring);
                                buf.append("<br>");
                                remainder = remainder.substring(idx);
                            }
                            buf.append(remainder);
                            buf.append("<br>");
                            continue;
                        }
                        buf.append(token);
                        buf.append("<br>");
                    }
                    continue;
                }
                buf.append(tagValue);
            }
            if (tagsHidden.size() > 0) {
                buf.append("<br>Hidden tags: " + String.join((CharSequence)", ", tagsHidden));
            }
        }
        return buf.toString();
    }

    @Override
    public String getSample() {
        return this.readGroupRecord == null ? null : this.readGroupRecord.getSample();
    }

    @Override
    public String getReadGroup() {
        return this.readGroupRecord == null ? null : this.readGroupRecord.getId();
    }

    @Override
    public String getLibrary() {
        return this.readGroupRecord == null ? null : this.readGroupRecord.getLibrary();
    }
}

