/*
 * Decompiled with CFR 0.152.
 */
package free.jin.action;

import free.jin.Connection;
import free.jin.I18n;
import free.jin.Preferences;
import free.jin.Server;
import free.jin.User;
import free.jin.action.ActionContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class JinAction
implements ActionListener {
    private ActionContext context;
    private Preferences prefs;
    private I18n i18n;

    public boolean setContext(ActionContext actionContext) {
        if (this.context != null) {
            throw new IllegalStateException("ActionContext already set");
        }
        this.context = actionContext;
        return this.isContextSupported(actionContext);
    }

    protected boolean isContextSupported(ActionContext actionContext) {
        return true;
    }

    public Connection getConn() {
        return this.context.getConnection();
    }

    public User getUser() {
        return this.context.getUser();
    }

    public Server getServer() {
        return this.getUser().getServer();
    }

    public Preferences getPrefs() {
        if (this.prefs == null) {
            Preferences preferences = this.context.getPreferences();
            Preferences preferences2 = this.getUser().getPrefs();
            this.prefs = Preferences.createBackedUp(Preferences.createWrapped(preferences2, "action." + this.getId() + "."), preferences);
        }
        return this.prefs;
    }

    public I18n getI18n() {
        if (this.i18n == null) {
            this.i18n = I18n.get(this.getClass(), JinAction.class);
        }
        return this.i18n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.go(actionEvent.getSource());
    }

    public abstract void go(Object var1);

    public abstract String getName();

    public abstract String getId();
}

