/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.OfflineChangeLogHistoryService;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.parser.SnapshotParser;
import liquibase.parser.SnapshotParserFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.util.ObjectUtil;
import liquibase.util.StringUtils;

public class OfflineConnection
implements DatabaseConnection {
    private final String url;
    private final String databaseShortName;
    private final Map<String, String> params = new HashMap<String, String>();
    private DatabaseSnapshot snapshot = null;
    private OutputLiquibaseSql outputLiquibaseSql = OutputLiquibaseSql.NONE;
    private String changeLogFile = "databasechangelog.csv";
    private boolean caseSensitive = false;
    private String productName;
    private String productVersion;
    private int databaseMajorVersion = 999;
    private int databaseMinorVersion = 999;
    private String catalog;
    private boolean sendsStringParametersAsUnicode = true;
    private final Map<String, String> databaseParams = new HashMap<String, String>();
    private String connectionUserName;

    public OfflineConnection(String url, ResourceAccessor resourceAccessor) {
        this.url = url;
        Matcher matcher = Pattern.compile("offline:(\\w+)\\??(.*)").matcher(url);
        if (!matcher.matches()) {
            throw new UnexpectedLiquibaseException("Could not parse offline url " + url);
        }
        this.databaseShortName = matcher.group(1).toLowerCase();
        String params = StringUtils.trimToNull(matcher.group(2));
        if (params != null) {
            String[] keyValues;
            for (String param : keyValues = params.split("&")) {
                String[] split = param.split("=");
                this.params.put(split[0], split[1]);
            }
        }
        this.productName = "Offline " + this.databaseShortName;
        for (Map.Entry<String, String> paramEntry : this.params.entrySet()) {
            if (paramEntry.getKey().equals("version")) {
                this.productVersion = paramEntry.getValue();
                String[] versionParts = this.productVersion.split("\\.");
                try {
                    this.databaseMajorVersion = Integer.parseInt(versionParts[0]);
                    if (versionParts.length <= 1) continue;
                    this.databaseMinorVersion = Integer.parseInt(versionParts[1]);
                }
                catch (NumberFormatException e) {
                    LogFactory.getInstance().getLog().warning("Cannot parse database version " + this.productVersion);
                }
                continue;
            }
            if (paramEntry.getKey().equals("productName")) {
                this.productName = paramEntry.getValue();
                continue;
            }
            if (paramEntry.getKey().equals("catalog")) {
                this.catalog = this.params.get("catalog");
                continue;
            }
            if (paramEntry.getKey().equals("caseSensitive")) {
                this.caseSensitive = Boolean.parseBoolean(paramEntry.getValue());
                continue;
            }
            if (paramEntry.getKey().equals("changeLogFile")) {
                this.changeLogFile = paramEntry.getValue();
                continue;
            }
            if (paramEntry.getKey().equals("outputLiquibaseSql")) {
                this.outputLiquibaseSql = OutputLiquibaseSql.fromString(paramEntry.getValue());
                continue;
            }
            if (paramEntry.getKey().equals("snapshot")) {
                String snapshotFile = paramEntry.getValue();
                try {
                    SnapshotParser parser = SnapshotParserFactory.getInstance().getParser(snapshotFile, resourceAccessor);
                    this.snapshot = parser.parse(snapshotFile, resourceAccessor);
                    this.snapshot.getDatabase().setConnection(this);
                    for (Catalog catalog : this.snapshot.get(Catalog.class)) {
                        if (!catalog.isDefault()) continue;
                        this.catalog = catalog.getName();
                    }
                    continue;
                }
                catch (LiquibaseException e) {
                    throw new UnexpectedLiquibaseException("Cannot parse snapshot " + url, e);
                }
            }
            if (paramEntry.getKey().equals("sendsStringParametersAsUnicode")) {
                this.sendsStringParametersAsUnicode = Boolean.parseBoolean(paramEntry.getValue());
                continue;
            }
            this.databaseParams.put(paramEntry.getKey(), paramEntry.getValue());
        }
    }

    public boolean isCorrectDatabaseImplementation(Database database) {
        return database.getShortName().equalsIgnoreCase(this.databaseShortName);
    }

    @Override
    public void attached(Database database) {
        for (Map.Entry<String, String> param : this.databaseParams.entrySet()) {
            try {
                ObjectUtil.setProperty((Object)database, param.getKey(), param.getValue());
            }
            catch (Throwable e) {
                LogFactory.getInstance().getLog().warning("Error setting database parameter " + param.getKey() + ": " + e.getMessage(), e);
            }
        }
        if (database instanceof AbstractJdbcDatabase) {
            ((AbstractJdbcDatabase)database).setCaseSensitive(this.caseSensitive);
        }
        ChangeLogHistoryServiceFactory.getInstance().register(this.createChangeLogHistoryService(database));
    }

    protected ChangeLogHistoryService createChangeLogHistoryService(Database database) {
        return new OfflineChangeLogHistoryService(database, new File(this.changeLogFile), this.outputLiquibaseSql != OutputLiquibaseSql.NONE, this.outputLiquibaseSql == OutputLiquibaseSql.ALL);
    }

    public DatabaseSnapshot getSnapshot(DatabaseObject[] examples) {
        return this.snapshot.clone(examples);
    }

    @Override
    public void close() throws DatabaseException {
    }

    @Override
    public void commit() throws DatabaseException {
    }

    @Override
    public boolean getAutoCommit() throws DatabaseException {
        return false;
    }

    @Override
    public String getCatalog() throws DatabaseException {
        return this.catalog;
    }

    public String getSchema() {
        if (this.snapshot == null) {
            return null;
        }
        for (Schema schema : this.snapshot.get(Schema.class)) {
            if (!schema.isDefault()) continue;
            return schema.getName();
        }
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws DatabaseException {
        return sql;
    }

    @Override
    public void rollback() throws DatabaseException {
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws DatabaseException {
    }

    @Override
    public String getDatabaseProductName() throws DatabaseException {
        return this.productName;
    }

    @Override
    public String getDatabaseProductVersion() throws DatabaseException {
        return this.productVersion;
    }

    @Override
    public int getDatabaseMajorVersion() throws DatabaseException {
        return this.databaseMajorVersion;
    }

    public void setDatabaseMajorVersion(int databaseMajorVersion) {
        this.databaseMajorVersion = databaseMajorVersion;
    }

    public void setDatabaseMinorVersion(int databaseMinorVersion) {
        this.databaseMinorVersion = databaseMinorVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @Override
    public int getDatabaseMinorVersion() throws DatabaseException {
        return this.databaseMinorVersion;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getConnectionUserName() {
        return this.connectionUserName;
    }

    public void setConnectionUserName(String connectionUserName) {
        this.connectionUserName = connectionUserName;
    }

    @Override
    public boolean isClosed() throws DatabaseException {
        return false;
    }

    public boolean getSendsStringParametersAsUnicode() {
        return this.sendsStringParametersAsUnicode;
    }

    public void setSendsStringParametersAsUnicode(boolean sendsStringParametersAsUnicode) {
        this.sendsStringParametersAsUnicode = sendsStringParametersAsUnicode;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    private static enum OutputLiquibaseSql {
        NONE,
        DATA_ONLY,
        ALL;


        public static OutputLiquibaseSql fromString(String s) {
            if (s == null) {
                return null;
            }
            if ((s = s.toUpperCase()).equals("TRUE")) {
                return ALL;
            }
            if (s.equals("FALSE")) {
                return NONE;
            }
            return OutputLiquibaseSql.valueOf(s);
        }
    }
}

