/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.CVSHistoryParser;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.RCSHistoryParser;
import org.opensolaris.opengrok.history.RCSRepository;
import org.opensolaris.opengrok.util.Executor;

public class CVSRepository
extends RCSRepository {
    private static final long serialVersionUID = 1L;
    public static final String CMD_PROPERTY_KEY = "org.opensolaris.opengrok.history.cvs";
    public static final String CMD_FALLBACK = "cvs";
    private Boolean isBranch = null;
    private String branch = null;
    private static final Pattern ANNOTATE_PATTERN = Pattern.compile("([\\.\\d]+)\\W+\\((\\w+)");

    public CVSRepository() {
        this.setType("CVS");
        this.setDatePattern("yyyy-MM-dd hh:mm:ss");
    }

    @Override
    public boolean isWorking() {
        if (this.working == null) {
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            this.working = CVSRepository.checkCmd(this.cmd, "--version");
        }
        return this.working;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDirectoryName(String directoryName) {
        super.setDirectoryName(directoryName);
        if (this.isWorking()) {
            String root;
            Logger logger = OpenGrokLogger.getLogger();
            File rootFile = new File(this.getDirectoryName() + File.separatorChar + "CVS" + File.separatorChar + "Root");
            try {
                BufferedReader input = new BufferedReader(new FileReader(rootFile));
                try {
                    root = input.readLine();
                }
                catch (IOException e) {
                    logger.warning("failed to load: " + e);
                    return;
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        logger.info("failed to close: " + e);
                    }
                }
            }
            catch (FileNotFoundException e) {
                logger.fine("not loading CVS Root file: " + e);
                return;
            }
            if (!root.startsWith("/")) {
                this.setRemote(true);
            }
        }
    }

    @Override
    File getRCSFile(File file) {
        File cvsFile = RCSHistoryParser.getCVSFile(file.getParent(), file.getName());
        if (cvsFile != null && cvsFile.exists()) {
            return cvsFile;
        }
        return null;
    }

    @Override
    public boolean isRepositoryFor(File file) {
        if (file.isDirectory()) {
            File cvsDir = new File(file, "CVS");
            return cvsDir.isDirectory();
        }
        return false;
    }

    @Override
    public void update() throws IOException {
        File directory = new File(this.getDirectoryName());
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("update");
        Executor executor = new Executor(cmd, directory);
        if (executor.exec() != 0) {
            throw new IOException(executor.getErrorString());
        }
    }

    Executor getHistoryLogExecutor(File file) throws IOException {
        String abs = file.getCanonicalPath();
        String filename = "";
        if (abs.length() > this.directoryName.length()) {
            filename = abs.substring(this.directoryName.length() + 1);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("log");
        if (this.isBranch == null) {
            File tagFile = new File(this.getDirectoryName(), "CVS/Tag");
            if (tagFile.isFile()) {
                this.isBranch = Boolean.TRUE;
                try (BufferedReader br = new BufferedReader(new FileReader(tagFile));){
                    String line = br.readLine();
                    if (line != null) {
                        this.branch = line.substring(1);
                    }
                }
                catch (IOException ex) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to work with CVS/Tag file of {0}", this.getDirectoryName() + ": " + ex.getClass().toString());
                }
                catch (Exception exp) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to get revision tag of {0}", this.getDirectoryName() + ": " + exp.getClass().toString());
                }
            } else {
                this.isBranch = Boolean.FALSE;
            }
        }
        if (this.isBranch.equals(Boolean.TRUE) && this.branch != null && !this.branch.isEmpty()) {
            cmd.add("-r" + this.branch);
        } else {
            cmd.add("-b");
        }
        if (filename.length() > 0) {
            cmd.add(filename);
        }
        return new Executor(cmd, new File(this.getDirectoryName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getHistoryGet(String parent, String basename, String rev) {
        ByteArrayInputStream ret = null;
        Process process = null;
        String revision = rev;
        if (rev.indexOf(58) != -1) {
            revision = rev.substring(0, rev.indexOf(58));
        }
        try {
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            String[] argv = new String[]{this.cmd, "up", "-p", "-r", revision, basename};
            process = Runtime.getRuntime().exec(argv, null, new File(parent));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[32768];
            try (InputStream in = process.getInputStream();){
                int len;
                while ((len = in.read(buffer)) != -1) {
                    if (len <= 0) continue;
                    out.write(buffer, 0, len);
                }
            }
            ret = new ByteArrayInputStream(out.toByteArray());
        }
        catch (Exception exp) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get history: {0}", exp.getClass().toString());
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException exp) {
                    process.destroy();
                }
            }
        }
        return ret;
    }

    @Override
    public boolean fileHasAnnotation(File file) {
        return true;
    }

    @Override
    public boolean fileHasHistory(File file) {
        return true;
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return new CVSHistoryParser().parse(file, this);
    }

    @Override
    Annotation annotate(File file, String revision) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("annotate");
        if (revision != null) {
            cmd.add("-r");
            cmd.add(revision);
        }
        cmd.add(file.getName());
        Executor exec = new Executor(cmd, file.getParentFile());
        int status = exec.exec();
        if (status != 0) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to get annotations for: \"{0}\" Exit code: {1}", new Object[]{file.getAbsolutePath(), String.valueOf(status)});
        }
        return this.parseAnnotation(exec.getOutputReader(), file.getName());
    }

    protected Annotation parseAnnotation(Reader input, String fileName) throws IOException {
        BufferedReader in = new BufferedReader(input);
        Annotation ret = new Annotation(fileName);
        String line = "";
        int lineno = 0;
        boolean hasStarted = false;
        Matcher matcher = ANNOTATE_PATTERN.matcher(line);
        while ((line = in.readLine()) != null) {
            if (!hasStarted && (line.length() == 0 || !Character.isDigit(line.charAt(0)))) continue;
            hasStarted = true;
            ++lineno;
            matcher.reset(line);
            if (matcher.find()) {
                String rev = matcher.group(1);
                String author = matcher.group(2).trim();
                ret.addLine(rev, author, true);
                continue;
            }
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Error: did not find annotation in line {0}: [{1}]", new Object[]{String.valueOf(lineno), line});
        }
        return ret;
    }
}

