/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.GitRepository;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.Executor;
import org.opensolaris.opengrok.util.StringUtils;

class GitHistoryParser
implements Executor.StreamHandler {
    private String myDir;
    private History history;
    private GitRepository repository = new GitRepository();

    GitHistoryParser() {
    }

    @Override
    public void processStream(InputStream input) throws IOException {
        try (BufferedReader in = new BufferedReader(this.repository.newLogReader(input));){
            this.process(in);
        }
    }

    private void process(BufferedReader in) throws IOException {
        DateFormat df = this.repository.getDateFormat();
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        this.history = new History();
        HistoryEntry entry = null;
        ParseState state = ParseState.HEADER;
        String s = in.readLine();
        while (s != null) {
            if (state == ParseState.HEADER) {
                if (s.startsWith("commit")) {
                    if (entry != null) {
                        entries.add(entry);
                    }
                    entry = new HistoryEntry();
                    entry.setActive(true);
                    String commit = s.substring("commit".length()).trim();
                    entry.setRevision(commit);
                } else if (s.startsWith("Author:") && entry != null) {
                    entry.setAuthor(s.substring("Author:".length()).trim());
                } else if (s.startsWith("AuthorDate:") && entry != null) {
                    String dateString = s.substring("AuthorDate:".length()).trim();
                    try {
                        entry.setDate(df.parse(dateString));
                    }
                    catch (ParseException pe) {
                        OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to parse author date: " + s, pe);
                    }
                } else if (StringUtils.isOnlyWhitespace(s)) {
                    state = ParseState.MESSAGE;
                    s = in.readLine();
                }
            }
            if (state == ParseState.MESSAGE) {
                if (s.length() == 0 || Character.isWhitespace(s.charAt(0))) {
                    if (entry != null) {
                        entry.appendMessage(s);
                    }
                } else {
                    state = ParseState.FILES;
                }
            }
            if (state == ParseState.FILES) {
                if (StringUtils.isOnlyWhitespace(s) || s.startsWith("commit")) {
                    state = ParseState.HEADER;
                    continue;
                }
                if (entry != null) {
                    try {
                        File f = new File(this.myDir, s);
                        entry.addFile(env.getPathRelativeToSourceRoot(f, 0));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            }
            s = in.readLine();
        }
        if (entry != null) {
            entries.add(entry);
        }
        this.history.setHistoryEntries(entries);
    }

    History parse(File file, Repository repos, String sinceRevision) throws HistoryException {
        this.myDir = repos.getDirectoryName() + File.separator;
        this.repository = (GitRepository)repos;
        try {
            Executor executor = this.repository.getHistoryLogExecutor(file, sinceRevision);
            int status = executor.exec(true, this);
            if (status != 0) {
                throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\" Exit code: " + status);
            }
        }
        catch (IOException e) {
            throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\"", e);
        }
        return this.history;
    }

    History parse(String buffer) throws IOException {
        this.myDir = RuntimeEnvironment.getInstance().getSourceRootPath();
        this.processStream(new ByteArrayInputStream(buffer.getBytes("UTF-8")));
        return this.history;
    }

    private static enum ParseState {
        HEADER,
        MESSAGE,
        FILES;

    }
}

