/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.MercurialRepository;
import org.opensolaris.opengrok.util.Executor;

class MercurialHistoryParser
implements Executor.StreamHandler {
    private static final String DESC_PREFIX = "description: ";
    private List<HistoryEntry> entries = new ArrayList<HistoryEntry>();
    private final MercurialRepository repository;
    private final String mydir;
    private boolean isDir;
    private final List<String> renamedFiles = new ArrayList<String>();

    MercurialHistoryParser(MercurialRepository repository) {
        this.repository = repository;
        this.mydir = repository.getDirectoryName() + File.separator;
    }

    History parse(File file, String changeset) throws HistoryException {
        this.isDir = file.isDirectory();
        try {
            Executor executor = this.repository.getHistoryLogExecutor(file, changeset);
            int status = executor.exec(true, this);
            if (status != 0) {
                throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\" Exit code: " + status);
            }
        }
        catch (IOException e) {
            throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\"", e);
        }
        if (changeset != null) {
            this.repository.removeAndVerifyOldestChangeset(this.entries, changeset);
        }
        return new History(this.entries, this.renamedFiles);
    }

    @Override
    public void processStream(InputStream input) throws IOException {
        String s;
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        DateFormat df = this.repository.getDateFormat();
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        this.entries = new ArrayList<HistoryEntry>();
        HistoryEntry entry = null;
        while ((s = in.readLine()) != null) {
            if (s.startsWith("changeset: ")) {
                entry = new HistoryEntry();
                this.entries.add(entry);
                entry.setActive(true);
                entry.setRevision(s.substring("changeset: ".length()).trim());
                continue;
            }
            if (s.startsWith("user: ") && entry != null) {
                entry.setAuthor(s.substring("user: ".length()).trim());
                continue;
            }
            if (s.startsWith("date: ") && entry != null) {
                Date date = new Date();
                try {
                    date = df.parse(s.substring("date: ".length()).trim());
                }
                catch (ParseException pe) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Could not parse date: " + s, pe);
                }
                entry.setDate(date);
                continue;
            }
            if (s.startsWith("files: ") && entry != null) {
                String[] strings = s.split(" ");
                for (int ii = 1; ii < strings.length; ++ii) {
                    if (strings[ii].length() <= 0) continue;
                    File f = new File(this.mydir, strings[ii]);
                    try {
                        entry.addFile(env.getPathRelativeToSourceRoot(f, 0));
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (s.startsWith("file_copies: ") && entry != null && this.isDir) {
                String[] splitArray;
                s = s.replaceFirst("file_copies: ", "");
                for (String part : splitArray = s.split("\\)")) {
                    String[] move = part.split(" \\(");
                    File f = new File(this.mydir + move[0]);
                    if (move[0].isEmpty() || !f.exists() || this.renamedFiles.contains(move[0])) continue;
                    this.renamedFiles.add(move[0]);
                }
                continue;
            }
            if (s.startsWith(DESC_PREFIX) && entry != null) {
                entry.setMessage(this.decodeDescription(s));
                continue;
            }
            if (s.equals("mercurial_history_end_of_entry") && entry != null) {
                entry = null;
                continue;
            }
            if (s.length() <= 0) continue;
            OpenGrokLogger.getLogger().log(Level.WARNING, "Invalid/unexpected output {0} from hg log for repo {1}", new Object[]{s, this.repository.getDirectoryName()});
        }
    }

    private String decodeDescription(String line) {
        StringBuilder out = new StringBuilder();
        int value = 0;
        for (int i = DESC_PREFIX.length(); i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (Character.isDigit(ch)) {
                value = value * 10 + Character.getNumericValue(ch);
                continue;
            }
            if (ch != ';') continue;
            out.append((char)value);
            value = 0;
        }
        assert (value == 0) : "description did not end with a semi-colon";
        return out.toString();
    }
}

