/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import org.apache.commons.jrcs.rcs.Archive;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.ParseException;
import org.apache.commons.jrcs.rcs.Version;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.RCSRepository;
import org.opensolaris.opengrok.history.Repository;

class RCSHistoryParser {
    RCSHistoryParser() {
    }

    private static File readCVSRoot(File root, File CVSdir, String name) throws IOException {
        File atticFile;
        String filename;
        String cvsroot = RCSHistoryParser.readFirstLine(root);
        if (cvsroot == null) {
            return null;
        }
        if (cvsroot.charAt(0) != '/') {
            return null;
        }
        File repository = new File(CVSdir, "Repository");
        String repo = RCSHistoryParser.readFirstLine(repository);
        String dir = cvsroot + File.separatorChar + repo;
        File rcsFile = new File(dir, filename = name + ",v");
        if (!rcsFile.exists() && (atticFile = new File(dir + File.separatorChar + "Attic", filename)).exists()) {
            rcsFile = atticFile;
        }
        return rcsFile;
    }

    History parse(File file, Repository repos) throws HistoryException {
        try {
            return this.parseFile(file);
        }
        catch (IOException ioe) {
            throw new HistoryException(ioe);
        }
    }

    private History parseFile(File file) throws IOException {
        try {
            Archive archive = new Archive(RCSHistoryParser.getRCSFile(file).getPath());
            Version ver = archive.getRevisionVersion();
            Node n = archive.findNode(ver);
            n = n.root();
            ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
            this.traverse(n, entries);
            History history = new History();
            history.setHistoryEntries(entries);
            return history;
        }
        catch (ParseException pe) {
            throw RCSRepository.wrapInIOException("Could not parse file " + file.getPath(), pe);
        }
    }

    private void traverse(Node n, List<HistoryEntry> history) {
        if (n == null) {
            return;
        }
        this.traverse(n.getChild(), history);
        TreeMap brt = n.getBranches();
        if (brt != null) {
            for (Node b : brt.values()) {
                this.traverse(b, history);
            }
        }
        if (!n.isGhost()) {
            HistoryEntry entry = new HistoryEntry();
            entry.setRevision(n.getVersion().toString());
            entry.setDate(n.getDate());
            entry.setAuthor(n.getAuthor());
            entry.setMessage(n.getLog());
            entry.setActive(true);
            history.add(entry);
        }
    }

    protected static File getRCSFile(File file) {
        return RCSHistoryParser.getRCSFile(file.getParent(), file.getName());
    }

    protected static File getRCSFile(String parent, String name) {
        File rcsDir = new File(parent, "RCS");
        File rcsFile = new File(rcsDir, name + ",v");
        if (rcsFile.exists()) {
            return rcsFile;
        }
        return RCSHistoryParser.getCVSFile(parent, name);
    }

    protected static File getCVSFile(String parent, String name) {
        try {
            File root;
            File CVSdir = new File(parent, "CVS");
            if (CVSdir.isDirectory() && CVSdir.canRead() && (root = new File(CVSdir, "Root")).canRead()) {
                return RCSHistoryParser.readCVSRoot(root, CVSdir, name);
            }
        }
        catch (Exception e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to retrieve CVS file of parent: " + parent + ", name: " + name, e);
        }
        return null;
    }

    private static String readFirstLine(File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String string = in.readLine();
            return string;
        }
    }
}

