/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.management;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.timer.Timer;
import org.opensolaris.opengrok.Info;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.management.AgentIndexRunner;
import org.opensolaris.opengrok.management.JMXConfiguration;
import org.opensolaris.opengrok.management.Management;
import org.opensolaris.opengrok.management.TimerFilter;

public final class OGAgent {
    Properties props;
    private static final Logger log = Logger.getLogger("org.opensolaris.opengrok");
    private MBeanServer server = null;

    private static boolean loadProperties(File file, InputStream in, Properties props) {
        boolean ret = false;
        try (InputStream stream = file == null ? in : new FileInputStream(file);){
            props.load(stream);
            ret = true;
        }
        catch (IOException e) {
            System.err.println("Failed to read configuration");
            e.printStackTrace(System.err);
            ret = false;
        }
        return ret;
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        boolean success = OGAgent.loadProperties(null, OGAgent.class.getResourceAsStream("oga.properties"), props);
        File file = new File("/etc/opengrok/opengrok.properties");
        if (file.exists()) {
            success = OGAgent.loadProperties(file, null, props);
        }
        props.putAll((Map<?, ?>)System.getProperties());
        for (int i = 0; success && i < args.length; ++i) {
            if (args[i].startsWith("--agent=")) {
                props.setProperty("agent", args[i].substring("--agent=".length()));
                continue;
            }
            if (!args[i].startsWith("--config=")) continue;
            file = new File(args[i].substring("--config=".length()));
            if (file.exists()) {
                success = OGAgent.loadProperties(file, null, props);
                continue;
            }
            success = false;
            System.err.println("Cannot load file \"" + file.getAbsolutePath() + "\": No such file");
        }
        URI uri = null;
        if (success) {
            try {
                uri = new URI(props.getProperty("agent"));
            }
            catch (URISyntaxException ex) {
                success = false;
                System.err.println("Failed to decode agent url");
                ex.printStackTrace(System.err);
            }
        }
        if (success) {
            OGAgent.setIfNotSet(props, "org.opensolaris.opengrok.management.logging.path", uri.getPath() + "/log");
            OGAgent.setIfNotSet(props, "org.opensolaris.opengrok.configuration.file", uri.getPath() + "/etc/configuration.xml");
            OGAgent.setIfNotSet(props, "org.opensolaris.opengrok.management.host", uri.getHost());
            OGAgent.setIfNotSet(props, "org.opensolaris.opengrok.management.port", String.valueOf(uri.getPort()));
            OGAgent.setIfNotSet(props, "org.opensolaris.opengrok.management.rmi.port", String.valueOf(uri.getPort() + 1));
            OGAgent.setIfNotSet(props, "org.opensolaris.opengrok.management.url", "service:jmx:rmi://" + props.getProperty("org.opensolaris.opengrok.management.host") + ":" + props.getProperty("org.opensolaris.opengrok.management.port") + "/jndi/rmi://" + props.getProperty("org.opensolaris.opengrok.management.host") + ":" + props.getProperty("org.opensolaris.opengrok.management.rmi.port") + "/opengrok");
            success = OGAgent.createLogger(props);
        }
        if (success) {
            OGAgent oga = new OGAgent(props);
            try {
                oga.runOGA();
            }
            catch (MalformedURLException e) {
                log.log(Level.SEVERE, "Could not create connector server: " + e, e);
                System.exit(1);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not start connector server: " + e, e);
                System.exit(2);
            }
            catch (Exception ex) {
                Logger.getLogger(OGAgent.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(1);
            }
        } else {
            System.exit(1);
        }
    }

    private OGAgent(Properties props) {
        this.props = props;
    }

    private static void setIfNotSet(Properties props, String key, String val) {
        if (!props.keySet().contains(key)) {
            props.setProperty(key, val);
        }
    }

    public void runOGA() throws MalformedURLException, IOException, JMException {
        String javaver = System.getProperty("java.version");
        log.info("Starting " + Info.getFullVersion() + " JMX Agent, with java version " + javaver);
        ArrayList<MBeanServer> mbservs = MBeanServerFactory.findMBeanServer(null);
        log.fine("Finding MBeanservers, size " + mbservs.size());
        this.server = mbservs.isEmpty() ? MBeanServerFactory.createMBeanServer() : mbservs.get(0);
        ObjectName manager = new ObjectName("OGA:name=Management");
        this.server.registerMBean(Management.getInstance(this.props), manager);
        ObjectName config = new ObjectName("OGA:name=JMXConfiguration");
        JMXConfiguration jc = new JMXConfiguration();
        this.server.registerMBean(jc, config);
        this.createIndexTimer(this.props);
        log.info("MBeans registered");
        String urlString = this.props.getProperty("org.opensolaris.opengrok.management.url");
        HashMap env = new HashMap();
        JMXServiceURL url = new JMXServiceURL(urlString);
        if (url.getProtocol().equals("rmi") && Boolean.parseBoolean(this.props.getProperty("org.opensolaris.opengrok.management.rmi.startRegistry"))) {
            int rmiport = Integer.parseInt(this.props.getProperty("org.opensolaris.opengrok.management.rmi.port"));
            log.log(Level.FINE, "Starting RMI registry on port {0}", rmiport);
            LocateRegistry.createRegistry(rmiport);
        }
        log.log(Level.FINE, "Starting JMX connector on {0}", urlString);
        JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, env, this.server);
        connectorServer.start();
        log.info("OGA is ready and running...");
    }

    private void createIndexTimer(Properties properties) throws JMException {
        ObjectName timer = new ObjectName("service:name=timer");
        this.server.registerMBean(new Timer(), timer);
        this.server.invoke(timer, "start", null, null);
        log.info("Started timer service");
        boolean enabled = Boolean.parseBoolean(properties.getProperty("org.opensolaris.opengrok.management.indexer.enabled"));
        int period = Integer.parseInt(properties.getProperty("org.opensolaris.opengrok.management.indexer.sleeptime"));
        log.fine("Indexer enabled: " + enabled);
        log.fine("Indexer period: " + period + " seconds");
        ObjectName indexRunner = new ObjectName("OGA:name=AgentIndexRunner,source=timer");
        this.server.registerMBean(AgentIndexRunner.getInstance(enabled), indexRunner);
        Date date = new Date(System.currentTimeMillis() + 5000L);
        Long longPeriod = (long)period * 1000L;
        Integer id = (Integer)this.server.invoke(timer, "addNotification", new Object[]{"timer.notification", "Time to index again", null, date, longPeriod}, new String[]{String.class.getName(), String.class.getName(), Object.class.getName(), Date.class.getName(), "long"});
        TimerFilter filter = new TimerFilter(id);
        this.server.addNotificationListener(timer, indexRunner, (NotificationFilter)filter, null);
    }

    private static boolean createLogger(Properties props) {
        boolean ret = true;
        String OGAlogpath = props.getProperty("org.opensolaris.opengrok.management.logging.path");
        Level loglevel = null;
        try {
            loglevel = Level.parse(props.getProperty("org.opensolaris.opengrok.management.logging.filelevel"));
        }
        catch (Exception exll) {
            loglevel = Level.FINE;
        }
        Level consoleloglevel = null;
        try {
            consoleloglevel = Level.parse(props.getProperty("org.opensolaris.opengrok.management.logging.consolelevel"));
        }
        catch (Exception excl) {
            consoleloglevel = Level.INFO;
        }
        try {
            OpenGrokLogger.setupLogger(OGAlogpath, loglevel, consoleloglevel);
        }
        catch (IOException ex) {
            System.err.println("OGAgent failed set up logging: " + ex);
            ret = false;
        }
        return ret;
    }
}

