/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.web;

public enum DiffType {
    SIDEBYSIDE('s', "sdiff"),
    UNIFIED('u', "udiff"),
    TEXT('t', "text"),
    OLD('o', "old"),
    NEW('n', "new");

    private char abbrev;
    private String name;

    private DiffType(char abbrev, String name) {
        this.abbrev = abbrev;
        this.name = name;
    }

    public static final DiffType get(char c) {
        for (DiffType d : DiffType.values()) {
            if (c != d.abbrev) continue;
            return d;
        }
        return null;
    }

    public static final DiffType get(String c) {
        if (c == null || c.length() == 0) {
            return null;
        }
        if (c.length() == 1) {
            return DiffType.get(c.charAt(0));
        }
        for (DiffType d : DiffType.values()) {
            if (!d.name.equals(c)) continue;
            return d;
        }
        return DiffType.get(c.charAt(0));
    }

    public char getAbbrev() {
        return this.abbrev;
    }

    public String toString() {
        return this.name;
    }
}

