/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.DiffAlgorithm;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;

public class SimpleDiff
implements DiffAlgorithm {
    static final int NOT_FOUND_i = -2;
    static final int NOT_FOUND_j = -1;
    static final int EOS = Integer.MAX_VALUE;

    protected int scan(int[] nArray, int n, int n2) {
        while (nArray[n] < n2) {
            ++n;
        }
        return n;
    }

    public Revision diff(Object[] objectArray, Object[] objectArray2) throws DifferentiationFailedException {
        Map map = this.buildEqSet(objectArray, objectArray2);
        int[] nArray = this.buildIndex(map, objectArray, -2);
        int[] nArray2 = this.buildIndex(map, objectArray2, -1);
        map = null;
        Revision revision = new Revision();
        int n = 0;
        int n2 = 0;
        while (nArray[n] != Integer.MAX_VALUE && nArray[n] == nArray2[n2]) {
            ++n;
            ++n2;
        }
        while (nArray[n] != nArray2[n2]) {
            int n3 = n;
            int n4 = n2;
            while (true) {
                if (nArray2[n2] < 0 || nArray2[n2] < nArray[n]) {
                    ++n2;
                    continue;
                }
                while (nArray[n] < 0 || nArray[n] < nArray2[n2]) {
                    ++n;
                }
                if (nArray[n] == nArray2[n2]) break;
            }
            while (n > n3 && n2 > n4 && nArray[n - 1] == nArray2[n2 - 1]) {
                --n;
                --n2;
            }
            revision.addDelta(Delta.newDelta(new Chunk(objectArray, n3, n - n3), new Chunk(objectArray2, n4, n2 - n4)));
            while (nArray[n] != Integer.MAX_VALUE && nArray[n] == nArray2[n2]) {
                ++n;
                ++n2;
            }
        }
        return revision;
    }

    protected Map buildEqSet(Object[] objectArray, Object[] objectArray2) {
        HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList(objectArray));
        hashSet.retainAll(Arrays.asList(objectArray2));
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!hashSet.contains(objectArray[i])) continue;
            hashMap.put(objectArray[i], new Integer(i));
            hashSet.remove(objectArray[i]);
        }
        return hashMap;
    }

    protected int[] buildIndex(Map map, Object[] objectArray, int n) {
        int[] nArray = new int[objectArray.length + 1];
        for (int i = 0; i < objectArray.length; ++i) {
            Integer n2 = (Integer)map.get(objectArray[i]);
            nArray[i] = n2 == null || n2 < 0 ? n : n2;
        }
        nArray[objectArray.length] = Integer.MAX_VALUE;
        return nArray;
    }
}

