/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.jrcs.rcs.Archive;
import org.apache.commons.jrcs.rcs.ArchiveParserConstants;
import org.apache.commons.jrcs.rcs.ArchiveParserTokenManager;
import org.apache.commons.jrcs.rcs.CharStream;
import org.apache.commons.jrcs.rcs.FastCharStream;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.ParseException;
import org.apache.commons.jrcs.rcs.Token;
import org.apache.commons.jrcs.rcs.Version;

class ArchiveParser
implements ArchiveParserConstants {
    static final String ident = "RCS ArchiveParser Parser $version$:";
    public ArchiveParserTokenManager token_source;
    public Token token;
    public Token jj_nt;

    public ArchiveParser(InputStream inputStream) {
        this(new FastCharStream(inputStream));
    }

    public static void main(String[] stringArray) {
        ArchiveParser archiveParser;
        if (stringArray.length == 0) {
            System.out.println("RCS ArchiveParser Parser $version$:  Reading from standard input . . .");
            archiveParser = new ArchiveParser(System.in);
        } else if (stringArray.length == 1) {
            System.out.println("RCS ArchiveParser Parser $version$:  Reading from file " + stringArray[0] + " . . .");
            try {
                archiveParser = new ArchiveParser(new FileInputStream(stringArray[0]));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("RCS ArchiveParser Parser $version$:  File " + stringArray[0] + " not found.");
                return;
            }
        } else {
            System.out.println("RCS ArchiveParser Parser $version$:  Usage is one of:");
            System.out.println("         java ArchiveParser < inputfile");
            System.out.println("OR");
            System.out.println("         java ArchiveParser inputfile");
            return;
        }
        archiveParser.parse();
    }

    public static void load(Archive archive, InputStream inputStream) throws ParseException {
        ArchiveParser archiveParser = new ArchiveParser(inputStream);
        archiveParser.archive(archive);
    }

    public static void load(Archive archive, String string) throws FileNotFoundException, ParseException {
        ArchiveParser.load(archive, new FileInputStream(string));
    }

    public void parse() {
        try {
            this.archive(null);
            System.out.println("RCS ArchiveParser Parser version 1.1:  RCS ArchiveParser parsed successfully.");
        }
        catch (ParseException parseException) {
            System.out.println("RCS ArchiveParser Parser version 1.1:  Encountered errors during parse.");
        }
    }

    public final void archive(Archive archive) throws ParseException {
        this.admin(archive);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 27: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            this.delta(archive);
        }
        this.desc(archive);
        block7: while (true) {
            switch (this.jj_nt.kind) {
                case 27: {
                    break;
                }
                default: {
                    break block7;
                }
            }
            this.text(archive);
        }
        this.jj_consume_token(0);
    }

    public final void admin(Archive archive) throws ParseException {
        this.head(archive);
        switch (this.jj_nt.kind) {
            case 8: {
                this.branch(archive);
                break;
            }
        }
        this.access(archive);
        this.symbols(archive);
        this.locks(archive);
        this.optionals(archive);
    }

    public final void optionals(Archive archive) throws ParseException {
        block9: {
            block8: while (true) {
                switch (this.jj_nt.kind) {
                    case 10: 
                    case 13: 
                    case 22: {
                        break;
                    }
                    default: {
                        break block9;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 10: {
                        this.comment(archive);
                        continue block8;
                    }
                    case 13: {
                        this.expand(archive);
                        continue block8;
                    }
                    case 22: {
                        this.newPhrase(archive.phrases);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void newPhrases(Map map) throws ParseException {
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.newPhrase(map);
        }
    }

    public final void head(Archive archive) throws ParseException {
        this.jj_consume_token(14);
        switch (this.jj_nt.kind) {
            case 27: {
                Version version = this.version();
                archive.setHead(version);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void branch(Archive archive) throws ParseException {
        this.jj_consume_token(8);
        switch (this.jj_nt.kind) {
            case 27: {
                Version version = this.version();
                archive.setBranch(version);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void access(Archive archive) throws ParseException {
        this.jj_consume_token(6);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            String string = this.id();
            archive.addUser(string);
        }
        this.jj_consume_token(28);
    }

    public final void symbols(Archive archive) throws ParseException {
        this.jj_consume_token(20);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            String string = this.sym();
            this.jj_consume_token(29);
            Version version = this.version();
            archive.addSymbol(string, version);
        }
        this.jj_consume_token(28);
    }

    public final void locks(Archive archive) throws ParseException {
        this.jj_consume_token(15);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 22: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            String string = this.id();
            this.jj_consume_token(29);
            Version version = this.version();
            archive.addLock(string, version);
        }
        this.jj_consume_token(28);
        switch (this.jj_nt.kind) {
            case 19: {
                this.jj_consume_token(19);
                this.jj_consume_token(28);
                archive.setStrictLocking(true);
                break;
            }
        }
    }

    public final void comment(Archive archive) throws ParseException {
        this.jj_consume_token(10);
        switch (this.jj_nt.kind) {
            case 24: {
                String string = this.string();
                archive.setComment(string);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void expand(Archive archive) throws ParseException {
        this.jj_consume_token(13);
        switch (this.jj_nt.kind) {
            case 24: {
                String string = this.string();
                archive.setExpand(string);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void newPhrase(Map map) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.id();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 22: 
                case 24: 
                case 27: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            String string2 = this.word();
            stringBuffer.append(" " + string2);
        }
        this.jj_consume_token(28);
        if (map != null) {
            map.put(string, stringBuffer.toString());
        }
    }

    public final String word() throws ParseException {
        String string = this.simpleWord();
        switch (this.jj_nt.kind) {
            case 29: {
                String string2 = this.range();
                string = string + string2;
                break;
            }
        }
        return string;
    }

    public final String simpleWord() throws ParseException {
        String string;
        switch (this.jj_nt.kind) {
            case 22: {
                string = this.id();
                break;
            }
            case 27: {
                Version version = this.version();
                string = version.toString();
                break;
            }
            case 24: {
                string = this.string();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    public final String range() throws ParseException {
        this.jj_consume_token(29);
        String string = this.simpleWord();
        return ":" + string;
    }

    public final void desc(Archive archive) throws ParseException {
        this.jj_consume_token(12);
        String string = this.string();
        archive.setDesc(string);
    }

    public final void delta(Archive archive) throws ParseException {
        Version version = this.version();
        Node node = archive.newNode(version);
        this.jj_consume_token(11);
        int[] nArray = this.date();
        node.setDate(nArray);
        this.jj_consume_token(28);
        this.jj_consume_token(7);
        String string = this.id();
        node.setAuthor(string);
        this.jj_consume_token(28);
        this.jj_consume_token(18);
        switch (this.jj_nt.kind) {
            case 22: {
                string = this.id();
                node.setState(string);
                break;
            }
        }
        this.jj_consume_token(28);
        this.jj_consume_token(9);
        block9: while (true) {
            switch (this.jj_nt.kind) {
                case 27: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            version = this.version();
            node.addBranch(archive.newBranchNode(version));
        }
        this.jj_consume_token(28);
        this.jj_consume_token(17);
        switch (this.jj_nt.kind) {
            case 27: {
                version = this.version();
                node.setRCSNext(archive.newNode(version));
                break;
            }
        }
        this.jj_consume_token(28);
        this.newPhrases(node.phrases);
    }

    public final void text(Archive archive) throws ParseException {
        Version version = this.version();
        Node node = archive.getNode(version);
        this.jj_consume_token(16);
        String string = this.string();
        node.setLog(string);
        this.newPhrases(node.phrases);
        this.jj_consume_token(21);
        String string2 = this.string();
        node.setText(string2);
    }

    public final String id() throws ParseException {
        Token token = this.jj_consume_token(22);
        return token.image;
    }

    public final String sym() throws ParseException {
        Token token;
        switch (this.jj_nt.kind) {
            case 23: {
                token = this.jj_consume_token(23);
                break;
            }
            case 22: {
                token = this.jj_consume_token(22);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token.image;
    }

    public final Version version() throws ParseException {
        int n = this.num();
        Version version = new Version(n);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 30: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(30);
            n = this.num();
            version.__addBranch(n);
        }
        return version;
    }

    public final int[] date() throws ParseException {
        int[] nArray = new int[6];
        nArray[0] = this.num();
        this.jj_consume_token(30);
        nArray[1] = this.num();
        this.jj_consume_token(30);
        nArray[2] = this.num();
        this.jj_consume_token(30);
        nArray[3] = this.num();
        this.jj_consume_token(30);
        nArray[4] = this.num();
        this.jj_consume_token(30);
        nArray[5] = this.num();
        return nArray;
    }

    public final int num() throws ParseException {
        Token token = this.jj_consume_token(27);
        return Integer.parseInt(token.image);
    }

    public final String string() throws ParseException {
        Token token = this.jj_consume_token(24);
        return Archive.unquoteString(token.image);
    }

    public ArchiveParser(CharStream charStream) {
        this.token_source = new ArchiveParserTokenManager(charStream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public void ReInit(CharStream charStream) {
        this.token_source.ReInit(charStream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public ArchiveParser(ArchiveParserTokenManager archiveParserTokenManager) {
        this.token_source = archiveParserTokenManager;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public void ReInit(ArchiveParserTokenManager archiveParserTokenManager) {
        this.token_source = archiveParserTokenManager;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == n) {
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = token;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    public ParseException generateParseException() {
        Token token = this.token.next;
        int n = token.beginLine;
        int n2 = token.beginColumn;
        String string = token.kind == 0 ? tokenImage[0] : token.image;
        return new ParseException("Parse error at line " + n + ", column " + n2 + ".  Encountered: " + string);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

