/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.rcs;

import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.rcs.Line;
import org.apache.commons.jrcs.rcs.Node;

class Lines
extends ArrayList {
    public static final Format annotationFormat = new MessageFormat("{0,,        } ({1} {2,  date,dd-MMM-yyyy}): {3}");

    public Lines() {
    }

    public Lines(String string) {
        this(null, Diff.stringToArray(string));
    }

    public Lines(Node node, String string) {
        this(node, Diff.stringToArray(string));
    }

    public Lines(Object[] objectArray) {
        this(null, objectArray);
    }

    public Lines(Node node, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            super.add(new Line(node, objectArray[i]));
        }
    }

    public boolean add(Object object) {
        return super.add((Line)object);
    }

    public Node[] nodesToArray() {
        Node[] nodeArray = new Node[this.size()];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = ((Line)this.get((int)i)).revision;
        }
        return nodeArray;
    }

    public Object[] textToArray() {
        return this.textToArray(false);
    }

    public Object[] textToArray(boolean bl) {
        Object[] objectArray = new Object[this.size()];
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Line line = (Line)iterator.next();
            Object object = line.getText();
            if (bl) {
                Node node = line.getRevision();
                object = annotationFormat.format(new Object[]{node.getVersion(), node.getAuthor(), node.getDate(), object});
            }
            objectArray[n++] = object;
        }
        return objectArray;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        return Diff.arrayToString(this.textToArray(bl));
    }
}

