require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_ENGINE_H)) {
    eval 'sub HEADER_ENGINE_H () {1;}' unless defined(&HEADER_ENGINE_H);
    require 'openssl/opensslconf.ph';
    unless(defined(&OPENSSL_NO_ENGINE)) {
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	    require 'openssl/bn.ph';
	    require 'openssl/rsa.ph';
	    require 'openssl/dsa.ph';
	    require 'openssl/dh.ph';
	    require 'openssl/ec.ph';
	    require 'openssl/rand.ph';
	    require 'openssl/ui.ph';
	    require 'openssl/err.ph';
	}
	require 'openssl/ossl_typ.ph';
	require 'openssl/symhacks.ph';
	require 'openssl/x509.ph';
	require 'openssl/engineerr.ph';
	if(defined(&__cplusplus)) {
	}
	eval 'sub ENGINE_METHOD_RSA () {0x1;}' unless defined(&ENGINE_METHOD_RSA);
	eval 'sub ENGINE_METHOD_DSA () {0x2;}' unless defined(&ENGINE_METHOD_DSA);
	eval 'sub ENGINE_METHOD_DH () {0x4;}' unless defined(&ENGINE_METHOD_DH);
	eval 'sub ENGINE_METHOD_RAND () {0x8;}' unless defined(&ENGINE_METHOD_RAND);
	eval 'sub ENGINE_METHOD_CIPHERS () {0x40;}' unless defined(&ENGINE_METHOD_CIPHERS);
	eval 'sub ENGINE_METHOD_DIGESTS () {0x80;}' unless defined(&ENGINE_METHOD_DIGESTS);
	eval 'sub ENGINE_METHOD_PKEY_METHS () {0x200;}' unless defined(&ENGINE_METHOD_PKEY_METHS);
	eval 'sub ENGINE_METHOD_PKEY_ASN1_METHS () {0x400;}' unless defined(&ENGINE_METHOD_PKEY_ASN1_METHS);
	eval 'sub ENGINE_METHOD_EC () {0x800;}' unless defined(&ENGINE_METHOD_EC);
	eval 'sub ENGINE_METHOD_ALL () {0xffff;}' unless defined(&ENGINE_METHOD_ALL);
	eval 'sub ENGINE_METHOD_NONE () {0x;}' unless defined(&ENGINE_METHOD_NONE);
	eval 'sub ENGINE_TABLE_FLAG_NOINIT () {0x1;}' unless defined(&ENGINE_TABLE_FLAG_NOINIT);
	eval 'sub ENGINE_FLAGS_MANUAL_CMD_CTRL () {0x2;}' unless defined(&ENGINE_FLAGS_MANUAL_CMD_CTRL);
	eval 'sub ENGINE_FLAGS_BY_ID_COPY () {0x4;}' unless defined(&ENGINE_FLAGS_BY_ID_COPY);
	eval 'sub ENGINE_FLAGS_NO_REGISTER_ALL () {0x8;}' unless defined(&ENGINE_FLAGS_NO_REGISTER_ALL);
	eval 'sub ENGINE_CMD_FLAG_NUMERIC () {0x1;}' unless defined(&ENGINE_CMD_FLAG_NUMERIC);
	eval 'sub ENGINE_CMD_FLAG_STRING () {0x2;}' unless defined(&ENGINE_CMD_FLAG_STRING);
	eval 'sub ENGINE_CMD_FLAG_NO_INPUT () {0x4;}' unless defined(&ENGINE_CMD_FLAG_NO_INPUT);
	eval 'sub ENGINE_CMD_FLAG_INTERNAL () {0x8;}' unless defined(&ENGINE_CMD_FLAG_INTERNAL);
	eval 'sub ENGINE_CTRL_SET_LOGSTREAM () {1;}' unless defined(&ENGINE_CTRL_SET_LOGSTREAM);
	eval 'sub ENGINE_CTRL_SET_PASSWORD_CALLBACK () {2;}' unless defined(&ENGINE_CTRL_SET_PASSWORD_CALLBACK);
	eval 'sub ENGINE_CTRL_HUP () {3;}' unless defined(&ENGINE_CTRL_HUP);
	eval 'sub ENGINE_CTRL_SET_USER_INTERFACE () {4;}' unless defined(&ENGINE_CTRL_SET_USER_INTERFACE);
	eval 'sub ENGINE_CTRL_SET_CALLBACK_DATA () {5;}' unless defined(&ENGINE_CTRL_SET_CALLBACK_DATA);
	eval 'sub ENGINE_CTRL_LOAD_CONFIGURATION () {6;}' unless defined(&ENGINE_CTRL_LOAD_CONFIGURATION);
	eval 'sub ENGINE_CTRL_LOAD_SECTION () {7;}' unless defined(&ENGINE_CTRL_LOAD_SECTION);
	eval 'sub ENGINE_CTRL_HAS_CTRL_FUNCTION () {10;}' unless defined(&ENGINE_CTRL_HAS_CTRL_FUNCTION);
	eval 'sub ENGINE_CTRL_GET_FIRST_CMD_TYPE () {11;}' unless defined(&ENGINE_CTRL_GET_FIRST_CMD_TYPE);
	eval 'sub ENGINE_CTRL_GET_NEXT_CMD_TYPE () {12;}' unless defined(&ENGINE_CTRL_GET_NEXT_CMD_TYPE);
	eval 'sub ENGINE_CTRL_GET_CMD_FROM_NAME () {13;}' unless defined(&ENGINE_CTRL_GET_CMD_FROM_NAME);
	eval 'sub ENGINE_CTRL_GET_NAME_LEN_FROM_CMD () {14;}' unless defined(&ENGINE_CTRL_GET_NAME_LEN_FROM_CMD);
	eval 'sub ENGINE_CTRL_GET_NAME_FROM_CMD () {15;}' unless defined(&ENGINE_CTRL_GET_NAME_FROM_CMD);
	eval 'sub ENGINE_CTRL_GET_DESC_LEN_FROM_CMD () {16;}' unless defined(&ENGINE_CTRL_GET_DESC_LEN_FROM_CMD);
	eval 'sub ENGINE_CTRL_GET_DESC_FROM_CMD () {17;}' unless defined(&ENGINE_CTRL_GET_DESC_FROM_CMD);
	eval 'sub ENGINE_CTRL_GET_CMD_FLAGS () {18;}' unless defined(&ENGINE_CTRL_GET_CMD_FLAGS);
	eval 'sub ENGINE_CMD_BASE () {200;}' unless defined(&ENGINE_CMD_BASE);
	eval 'sub ENGINE_CTRL_CHIL_SET_FORKCHECK () {100;}' unless defined(&ENGINE_CTRL_CHIL_SET_FORKCHECK);
	eval 'sub ENGINE_CTRL_CHIL_NO_LOCKING () {101;}' unless defined(&ENGINE_CTRL_CHIL_NO_LOCKING);
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	    eval 'sub ENGINE_load_openssl () {
	        eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_ENGINE_OPENSSL,  &NULL));
	    }' unless defined(&ENGINE_load_openssl);
	    eval 'sub ENGINE_load_dynamic () {
	        eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_ENGINE_DYNAMIC,  &NULL));
	    }' unless defined(&ENGINE_load_dynamic);
	    unless(defined(&OPENSSL_NO_STATIC_ENGINE)) {
		eval 'sub ENGINE_load_padlock () {
		    eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_ENGINE_PADLOCK,  &NULL));
		}' unless defined(&ENGINE_load_padlock);
		eval 'sub ENGINE_load_capi () {
		    eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_ENGINE_CAPI,  &NULL));
		}' unless defined(&ENGINE_load_capi);
		eval 'sub ENGINE_load_afalg () {
		    eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_ENGINE_AFALG,  &NULL));
		}' unless defined(&ENGINE_load_afalg);
	    }
	    eval 'sub ENGINE_load_cryptodev () {
	        eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_ENGINE_CRYPTODEV,  &NULL));
	    }' unless defined(&ENGINE_load_cryptodev);
	    eval 'sub ENGINE_load_rdrand () {
	        eval q( &OPENSSL_init_crypto( &OPENSSL_INIT_ENGINE_RDRAND,  &NULL));
	    }' unless defined(&ENGINE_load_rdrand);
	}
	eval 'sub ENGINE_get_ex_new_index {
	    my($l, $p, $newf, $dupf, $freef) = @_;
    	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_ENGINE, $l, $p, $newf, $dupf, $freef));
	}' unless defined(&ENGINE_get_ex_new_index);
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	    eval 'sub ENGINE_cleanup () {
	        eval q( &while(0)  &continue);
	    }' unless defined(&ENGINE_cleanup);
	}
	eval 'sub OSSL_DYNAMIC_VERSION () {0x30000;}' unless defined(&OSSL_DYNAMIC_VERSION);
	eval 'sub OSSL_DYNAMIC_OLDEST () {0x30000;}' unless defined(&OSSL_DYNAMIC_OLDEST);
	eval 'sub IMPLEMENT_DYNAMIC_CHECK_FN () {
	    eval q( &OPENSSL_EXPORT  &unsigned long v_check;  &OPENSSL_EXPORT  &unsigned long v_check {  &if ( &v >=  &OSSL_DYNAMIC_OLDEST)  &return  &OSSL_DYNAMIC_VERSION;  &return 0; });
	}' unless defined(&IMPLEMENT_DYNAMIC_CHECK_FN);
	eval 'sub IMPLEMENT_DYNAMIC_BIND_FN {
	    my($fn) = @_;
    	    eval q( &OPENSSL_EXPORT \'int\'  &bind_engine( &ENGINE * &e,  &const \'char\' * &id,  &const  &dynamic_fns * &fns);  &OPENSSL_EXPORT \'int\'  &bind_engine( &ENGINE * &e,  &const \'char\' * &id,  &const  &dynamic_fns * &fns) {  &if ( &ENGINE_get_static_state() ==  ($fns->{static_state}))  &goto  &skip_cbs;  &CRYPTO_set_mem_functions( ($fns->{mem_fns}->{malloc_fn}),  ($fns->{mem_fns}->{realloc_fn}),  ($fns->{mem_fns}->{free_fn}));  &OPENSSL_init_crypto( &OPENSSL_INIT_NO_ATEXIT,  &NULL);  &skip_cbs:  &if (!$fn( &e,  &id))  &return 0;  &return 1; });
	}' unless defined(&IMPLEMENT_DYNAMIC_BIND_FN);
	if(defined(&__OpenBSD__) || defined(&__FreeBSD__) || defined(&__DragonFly__)) {
	}
	if(defined(&__cplusplus)) {
	}
    }
}
1;
