require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_LWP_H_)) {
    eval 'sub _SYS_LWP_H_ () {1;}' unless defined(&_SYS_LWP_H_);
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	require 'sys/param.ph';
	require 'sys/time.ph';
	require 'sys/queue.ph';
	require 'sys/callout.ph';
	require 'sys/kcpuset.ph';
	require 'sys/mutex.ph';
	require 'sys/condvar.ph';
	require 'sys/signalvar.ph';
	require 'sys/sched.ph';
	require 'sys/specificdata.ph';
	require 'sys/syncobj.ph';
	require 'sys/resource.ph';
	if(defined(&_KERNEL)) {
	    require 'machine/cpu.ph';
	}
	require 'machine/proc.ph';
	require 'sys/pcu.ph';
	if((defined(&PCU_UNIT_COUNT) ? &PCU_UNIT_COUNT : undef) > 0) {
	}
	unless(defined(&UAREA_PCB_OFFSET)) {
	    eval 'sub UAREA_PCB_OFFSET () {0;}' unless defined(&UAREA_PCB_OFFSET);
	}
	if(defined(&_KERNEL)) {
	    unless(defined(&MAXLWP)) {
		eval 'sub MAXLWP () {2048;}' unless defined(&MAXLWP);
	    }
	    unless(defined(&__HAVE_CPU_MAXLWP)) {
		eval 'sub cpu_maxlwp () {
		    eval q( &MAXLWP);
		}' unless defined(&cpu_maxlwp);
	    }
	}
    }
    eval 'sub LW_IDLE () {0x1;}' unless defined(&LW_IDLE);
    eval 'sub LW_LWPCTL () {0x2;}' unless defined(&LW_LWPCTL);
    eval 'sub LW_CVLOCKDEBUG () {0x4;}' unless defined(&LW_CVLOCKDEBUG);
    eval 'sub LW_SINTR () {0x80;}' unless defined(&LW_SINTR);
    eval 'sub LW_SYSTEM () {0x200;}' unless defined(&LW_SYSTEM);
    eval 'sub LW_DBGSUSPEND () {0x10000;}' unless defined(&LW_DBGSUSPEND);
    eval 'sub LW_WSUSPEND () {0x20000;}' unless defined(&LW_WSUSPEND);
    eval 'sub LW_BATCH () {0x40000;}' unless defined(&LW_BATCH);
    eval 'sub LW_WCORE () {0x80000;}' unless defined(&LW_WCORE);
    eval 'sub LW_WEXIT () {0x100000;}' unless defined(&LW_WEXIT);
    eval 'sub LW_PENDSIG () {0x1000000;}' unless defined(&LW_PENDSIG);
    eval 'sub LW_CANCELLED () {0x2000000;}' unless defined(&LW_CANCELLED);
    eval 'sub LW_WREBOOT () {0x8000000;}' unless defined(&LW_WREBOOT);
    eval 'sub LW_UNPARKED () {0x10000000;}' unless defined(&LW_UNPARKED);
    eval 'sub LW_RUMP_CLEAR () {0x40000000;}' unless defined(&LW_RUMP_CLEAR);
    eval 'sub LW_RUMP_QEXIT () {0x80000000;}' unless defined(&LW_RUMP_QEXIT);
    eval 'sub LP_KTRACTIVE () {0x1;}' unless defined(&LP_KTRACTIVE);
    eval 'sub LP_KTRCSW () {0x2;}' unless defined(&LP_KTRCSW);
    eval 'sub LP_KTRCSWUSER () {0x4;}' unless defined(&LP_KTRCSWUSER);
    eval 'sub LP_PIDLID () {0x8;}' unless defined(&LP_PIDLID);
    eval 'sub LP_OWEUPC () {0x10;}' unless defined(&LP_OWEUPC);
    eval 'sub LP_MPSAFE () {0x20;}' unless defined(&LP_MPSAFE);
    eval 'sub LP_INTR () {0x40;}' unless defined(&LP_INTR);
    eval 'sub LP_SYSCTLWRITE () {0x80;}' unless defined(&LP_SYSCTLWRITE);
    eval 'sub LP_MUSTJOIN () {0x100;}' unless defined(&LP_MUSTJOIN);
    eval 'sub LP_SINGLESTEP () {0x400;}' unless defined(&LP_SINGLESTEP);
    eval 'sub LP_TIMEINTR () {0x10000;}' unless defined(&LP_TIMEINTR);
    eval 'sub LP_PREEMPTING () {0x20000;}' unless defined(&LP_PREEMPTING);
    eval 'sub LP_RUNNING () {0x20000000;}' unless defined(&LP_RUNNING);
    eval 'sub LP_BOUND () {0x80000000;}' unless defined(&LP_BOUND);
    eval 'sub LPR_DETACHED () {0x800000;}' unless defined(&LPR_DETACHED);
    eval 'sub LPR_CRMOD () {0x100;}' unless defined(&LPR_CRMOD);
    eval 'sub LW_USERRET () {( &LW_WEXIT |  &LW_PENDSIG |  &LW_WREBOOT |  &LW_WSUSPEND |  &LW_WCORE |  &LW_LWPCTL);}' unless defined(&LW_USERRET);
    eval 'sub LSIDL () {1;}' unless defined(&LSIDL);
    eval 'sub LSRUN () {2;}' unless defined(&LSRUN);
    eval 'sub LSSLEEP () {3;}' unless defined(&LSSLEEP);
    eval 'sub LSSTOP () {4;}' unless defined(&LSSTOP);
    eval 'sub LSZOMB () {5;}' unless defined(&LSZOMB);
    eval 'sub LSONPROC () {7;}' unless defined(&LSONPROC);
    eval 'sub LSSUSPENDED () {8;}' unless defined(&LSSUSPENDED);
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	eval 'sub lwp_getpcb {
	    my($l) = @_;
    	    eval q({  ($l->{l_addr}); });
	}' unless defined(&lwp_getpcb);
    }
    if(defined(&_KERNEL)) {
	eval 'sub LWP_CACHE_CREDS {
	    my($l, $p) = @_;
    	    eval q( &do { ( &void)$p;  &if ( &__predict_false(($l)-> &l_prflag &  &LPR_CRMOD))  &lwp_update_creds($l); }  &while ( 0));
	}' unless defined(&LWP_CACHE_CREDS);
	if(defined(&_LWP_API_PRIVATE)) {
	}
	eval 'sub lwp_changepri {
	    my($l,$pri) = @_;
    	    eval q({  &KASSERT( &mutex_owned( ($l->{l_mutex})));  &if ( ($l->{l_priority}) == $pri) ; (* ($l->{l_syncobj}->{sobj_changepri}))($l, $pri);  &KASSERT( ($l->{l_priority}) == $pri); });
	}' unless defined(&lwp_changepri);
	eval 'sub lwp_lendpri {
	    my($l,$pri) = @_;
    	    eval q({  &KASSERT( &mutex_owned( ($l->{l_mutex}))); (* ($l->{l_syncobj}->{sobj_lendpri}))($l, $pri);  &KASSERT( ($l->{l_inheritedprio}) == $pri); });
	}' unless defined(&lwp_lendpri);
	eval 'sub lwp_eprio {
	    my($l) = @_;
    	    eval q({  &pri_t  &pri;  &pri =  ($l->{l_priority});  &if (( ($l->{l_flag}) &  &LW_SYSTEM) == 0 &&  ($l->{l_kpriority})  &&  &pri <  &PRI_KERNEL)  &pri = ( &pri >> 1) +  ($l->{l_kpribase});  &MAX( ($l->{l_auxprio}),  &pri); });
	}' unless defined(&lwp_eprio);
	eval 'sub spc_unlock {
	    my($ci) = @_;
    	    eval q({  &mutex_spin_exit( ($ci->{ci_schedstate}->{spc_mutex})); });
	}' unless defined(&spc_unlock);
	eval 'sub spc_dlock {
	    my($ci1,$ci2) = @_;
    	    eval q({ \'struct schedstate_percpu\' * &spc1 =  ($ci1->{ci_schedstate}); \'struct schedstate_percpu\' * &spc2 =  ($ci2->{ci_schedstate});  &KASSERT($ci1 != $ci2);  &if ($ci1 < $ci2) {  &mutex_spin_enter( ($spc1->{spc_mutex}));  &mutex_spin_enter( ($spc2->{spc_mutex})); }  &else {  &mutex_spin_enter( ($spc2->{spc_mutex}));  &mutex_spin_enter( ($spc1->{spc_mutex})); } });
	}' unless defined(&spc_dlock);
	if(!defined(&curlwp)) {
	    if(defined(&MULTIPROCESSOR)) {
		eval 'sub curlwp () { &curcpu()-> &ci_curlwp;}' unless defined(&curlwp);
	    } else {
	    }
	}
	eval 'sub curproc () {( ($curlwp->{l_proc}));}' unless defined(&curproc);
	eval 'sub CURCPU_IDLE_P {
	    my($void) = @_;
    	    eval q({ \'struct cpu_info\' * &ci =  &curcpu();  ($ci->{ci_data}->{cpu_onproc}) ==  ($ci->{ci_data}->{cpu_idlelwp}); });
	}' unless defined(&CURCPU_IDLE_P);
	eval 'sub KPREEMPT_ENABLE {
	    my($l) = @_;
    	    eval q({  &KASSERT($l ==  &curlwp);  &KASSERT( ($l->{l_nopreempt}) > 0);  &__insn_barrier();  &if (-- ($l->{l_nopreempt}) != 0) ;  &__insn_barrier();  &if ( &__predict_false( ($l->{l_dopreempt})))  &kpreempt(0);  &__insn_barrier(); });
	}' unless defined(&KPREEMPT_ENABLE);
	eval 'sub DOPREEMPT_ACTIVE () {0x1;}' unless defined(&DOPREEMPT_ACTIVE);
	eval 'sub DOPREEMPT_COUNTED () {0x2;}' unless defined(&DOPREEMPT_COUNTED);
	eval 'sub curlwp_bindx {
	    my($bound) = @_;
    	    eval q({  &KASSERT( ($curlwp->{l_pflag}) &  &LP_BOUND);  &__insn_barrier();  ($curlwp->{l_pflag}) ^= $bound ^  &LP_BOUND; });
	}' unless defined(&curlwp_bindx);
    }
    eval 'sub LWP_DETACHED () {0x40;}' unless defined(&LWP_DETACHED);
    eval 'sub LWP_SUSPENDED () {0x80;}' unless defined(&LWP_SUSPENDED);
    eval 'sub LWP_PIDLID () {0x40000000;}' unless defined(&LWP_PIDLID);
    eval 'sub LWP_VFORK () {0x80000000;}' unless defined(&LWP_VFORK);
}
1;
