/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ServerSocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ReflectionSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.parosproxy.paros.network.RelaxedX509TrustManager;

public class SSLConnector
implements SecureProtocolSocketFactory {
    private static final String SSL = "SSL";
    private static SSLSocketFactory clientSSLSockFactory = null;
    private static SSLSocketFactory clientSSLSockCertFactory = null;
    private static ServerSocketFactory serverSSLSockFactory = null;
    private static SSLSocketFactory tunnelSSLFactory = null;

    public SSLConnector() {
        if (clientSSLSockFactory == null) {
            clientSSLSockFactory = this.getClientSocketFactory(SSL);
        }
        if (serverSSLSockFactory == null) {
            serverSSLSockFactory = this.getServerSocketFactory(SSL);
        }
    }

    public SSLSocket client(String string, int n, boolean bl) throws IOException {
        SSLSocket sSLSocket = null;
        sSLSocket = this.clientNoHandshake(string, n, bl);
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    public SSLSocket clientNoHandshake(String string, int n, boolean bl) throws IOException {
        SSLSocket sSLSocket = null;
        sSLSocket = bl ? (SSLSocket)clientSSLSockCertFactory.createSocket(string, n) : (SSLSocket)clientSSLSockFactory.createSocket(string, n);
        return sSLSocket;
    }

    public void setClientCert(File file, char[] cArray) throws Exception {
        clientSSLSockCertFactory = null;
        TrustManager[] trustManagerArray = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext sSLContext = SSLContext.getInstance(SSL);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        KeyStore keyStore = KeyStore.getInstance("pkcs12");
        keyStore.load(new FileInputStream(file), cArray);
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(System.currentTimeMillis());
        keyManagerFactory.init(keyStore, cArray);
        sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, secureRandom);
        clientSSLSockCertFactory = sSLContext.getSocketFactory();
    }

    public void setEnableClientCert(boolean bl) {
        clientSSLSockFactory = bl ? clientSSLSockCertFactory : this.getClientSocketFactory(SSL);
    }

    public ServerSocket listen(int n) throws IOException {
        ServerSocket serverSocket = null;
        serverSocket = serverSSLSockFactory.createServerSocket(n);
        return serverSocket;
    }

    public ServerSocket listen() throws IOException {
        ServerSocket serverSocket = null;
        serverSocket = serverSSLSockFactory.createServerSocket();
        return serverSocket;
    }

    public ServerSocket listen(int n, int n2) throws IOException {
        ServerSocket serverSocket = null;
        serverSocket = serverSSLSockFactory.createServerSocket(n, n2);
        return serverSocket;
    }

    public ServerSocket listen(int n, int n2, InetAddress inetAddress) throws IOException {
        ServerSocket serverSocket = serverSSLSockFactory.createServerSocket(n, n2, inetAddress);
        return serverSocket;
    }

    public SSLSocketFactory getClientSocketFactory(String string) {
        TrustManager[] trustManagerArray = new TrustManager[]{new RelaxedX509TrustManager()};
        try {
            SSLContext sSLContext = SSLContext.getInstance(string);
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.setSeed(System.currentTimeMillis());
            sSLContext.init(null, trustManagerArray, secureRandom);
            clientSSLSockFactory = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(clientSSLSockFactory);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return clientSSLSockFactory;
    }

    public ServerSocketFactory getServerSocketFactory(String string) {
        if (string.equals(SSL) || string.equals("SSLv3")) {
            SSLServerSocketFactory sSLServerSocketFactory = null;
            try {
                char[] cArray = "!@#$%^&*()".toCharArray();
                SSLContext sSLContext = SSLContext.getInstance(string);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                KeyStore keyStore = KeyStore.getInstance("JKS");
                SecureRandom secureRandom = new SecureRandom();
                secureRandom.setSeed(System.currentTimeMillis());
                keyStore.load(this.getClass().getClassLoader().getResourceAsStream("resource/paroskey"), cArray);
                keyManagerFactory.init(keyStore, cArray);
                sSLContext.init(keyManagerFactory.getKeyManagers(), null, secureRandom);
                sSLServerSocketFactory = sSLContext.getServerSocketFactory();
                tunnelSSLFactory = sSLContext.getSocketFactory();
                return sSLServerSocketFactory;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            return ServerSocketFactory.getDefault();
        }
        return null;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        Socket socket = clientSSLSockFactory.createSocket(string, n, inetAddress, n2);
        return socket;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n3 = httpConnectionParams.getConnectionTimeout();
        if (n3 == 0) {
            return this.createSocket(string, n, inetAddress, n2);
        }
        Socket socket = ReflectionSocketFactory.createSocket("javax.net.ssl.SSLSocketFactory", string, n, inetAddress, n2, n3);
        if (socket == null) {
            socket = ControllerThreadSocketFactory.createSocket(this, string, n, inetAddress, n2, n3);
        }
        return socket;
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return clientSSLSockFactory.createSocket(string, n);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        return clientSSLSockFactory.createSocket(socket, string, n, bl);
    }

    public Socket createTunnelServerSocket(Socket socket) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)tunnelSSLFactory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        sSLSocket.setUseClientMode(false);
        sSLSocket.startHandshake();
        return sSLSocket;
    }
}

