/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io.win32;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WindowsElevationUtil {
    private static Logger LOG = Logger.getInstance(WindowsElevationUtil.class);
    private static final AtomicNotNullLazyValue<Boolean> IS_UNDER_ELEVATION = new AtomicNotNullLazyValue<Boolean>(){

        @Override
        @NotNull
        protected Boolean compute() {
            Boolean bl;
            if (!SystemInfo.isWindows) {
                Boolean bl2 = false;
                if (bl2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return bl2;
            }
            try {
                bl = this.isElevated();
            }
            catch (Throwable t) {
                LOG.warn("Unexpected exception in WindowsElevationUtil.IS_UNDER_ELEVATION", t);
                Boolean bl3 = false;
                if (bl3 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return bl3;
            }
            if (bl == null) {
                1.$$$reportNull$$$0(1);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isElevated() {
            WinNT.HANDLEByReference processTokenHandle = new WinNT.HANDLEByReference();
            boolean openProcessRc = Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 40, processTokenHandle);
            if (!openProcessRc) {
                int lastError = Kernel32.INSTANCE.GetLastError();
                LOG.warn("Unable to OpenProcessToken: error " + lastError + ": " + Kernel32Util.formatMessageFromLastErrorCode((int)lastError));
                return false;
            }
            try {
                IntByReference cbNeeded = new IntByReference(0);
                TOKEN_ELEVATION tokenElevation = new TOKEN_ELEVATION();
                boolean getTokenInformationRc = Advapi32.INSTANCE.GetTokenInformation(processTokenHandle.getValue(), 20, (Structure)tokenElevation, tokenElevation.size(), cbNeeded);
                if (!getTokenInformationRc) {
                    int lastError = Kernel32.INSTANCE.GetLastError();
                    LOG.warn("Unable to GetTokenInformation: error " + lastError + ": " + Kernel32Util.formatMessageFromLastErrorCode((int)lastError));
                    boolean bl = false;
                    return bl;
                }
                boolean bl = tokenElevation.TokenIsElevated.intValue() != 0;
                return bl;
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(processTokenHandle.getValue());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/win32/WindowsElevationUtil$1", "compute"));
        }
    };

    private WindowsElevationUtil() {
    }

    public static boolean isUnderElevation() {
        return IS_UNDER_ELEVATION.getValue();
    }

    public static class TOKEN_ELEVATION
    extends Structure {
        public WinDef.DWORD TokenIsElevated = new WinDef.DWORD(0L);
        private static List<String> FIELDS = TOKEN_ELEVATION.createFieldsOrder((String)"TokenIsElevated");

        protected List<String> getFieldOrder() {
            return FIELDS;
        }
    }
}

