/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections.model;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.inspections.model.FileTypeComboboxItem;

public class CreateStepDefinitionFileModel {
    private String myFileName;
    private final Map<BDDFrameworkType, PsiDirectory> myFileTypeToDefaultDirectoryMap;
    DefaultComboBoxModel myFileTypeModel;
    private PsiDirectory myDirectory;
    private final Project myProject;

    public CreateStepDefinitionFileModel(@NotNull Project project, @NotNull Map<BDDFrameworkType, String> fileTypeToDefaultNameMap, @NotNull Map<BDDFrameworkType, PsiDirectory> fileTypeToDefaultDirectoryMap) {
        if (project == null) {
            CreateStepDefinitionFileModel.$$$reportNull$$$0(0);
        }
        if (fileTypeToDefaultNameMap == null) {
            CreateStepDefinitionFileModel.$$$reportNull$$$0(1);
        }
        if (fileTypeToDefaultDirectoryMap == null) {
            CreateStepDefinitionFileModel.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        ArrayList<FileTypeComboboxItem> myFileTypeList = new ArrayList<FileTypeComboboxItem>();
        for (Map.Entry<BDDFrameworkType, String> entry : fileTypeToDefaultNameMap.entrySet()) {
            if (this.myFileName == null) {
                this.myFileName = entry.getValue();
            }
            FileTypeComboboxItem item = new FileTypeComboboxItem(entry.getKey(), entry.getValue());
            myFileTypeList.add(item);
        }
        this.myFileTypeToDefaultDirectoryMap = fileTypeToDefaultDirectoryMap;
        this.myFileTypeModel = new DefaultComboBoxModel<Object>(myFileTypeList.toArray());
        this.myDirectory = fileTypeToDefaultDirectoryMap.get(this.getSelectedFileType());
    }

    public String getFilePath() {
        StringBuilder result = new StringBuilder();
        result.append(this.getDirectory().getVirtualFile().getPath()).append(File.separator).append(this.getFileNameWithExtension());
        return result.toString();
    }

    public String getFileNameWithExtension() {
        StringBuilder result = new StringBuilder();
        result.append(this.myFileName).append('.').append(this.getSelectedFileType().getFileType().getDefaultExtension());
        return result.toString();
    }

    public String getFileName() {
        return this.myFileName;
    }

    public void setFileName(@NotNull String fileName) {
        if (fileName == null) {
            CreateStepDefinitionFileModel.$$$reportNull$$$0(3);
        }
        this.myFileName = fileName;
    }

    public PsiDirectory getDefaultDirectory() {
        return this.myFileTypeToDefaultDirectoryMap.get(this.getSelectedFileType());
    }

    public PsiDirectory getDirectory() {
        return this.myDirectory;
    }

    public void setDirectory(@Nullable PsiDirectory psiDirectory) {
        this.myDirectory = psiDirectory;
    }

    public BDDFrameworkType getSelectedFileType() {
        FileTypeComboboxItem selectedItem = (FileTypeComboboxItem)this.myFileTypeModel.getSelectedItem();
        return selectedItem != null ? selectedItem.getFrameworkType() : null;
    }

    public DefaultComboBoxModel getFileTypeModel() {
        return this.myFileTypeModel;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeToDefaultNameMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeToDefaultDirectoryMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/model/CreateStepDefinitionFileModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setFileName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

