/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.statistics;

import com.intellij.internal.statistic.service.fus.collectors.FUSProjectUsageTrigger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.composer.actions.ComposerOptionsManager;
import com.jetbrains.php.composer.statistics.ComposerActionUsageCollector;
import com.jetbrains.php.composer.statistics.ComposerCommandOptionsUsageCollector;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerActionStatistics {
    @NotNull
    private final String action;
    @NotNull
    private final String place;
    @Nullable
    private final String commandLineOptions;
    @Nullable
    private final ComposerOptionsManager.Command command;
    private boolean isReported;

    public static ComposerActionStatistics create(@NotNull String action, @NotNull String place, @NotNull ComposerOptionsManager.Command command, @Nullable String commandLineOptions) {
        if (action == null) {
            ComposerActionStatistics.$$$reportNull$$$0(0);
        }
        if (place == null) {
            ComposerActionStatistics.$$$reportNull$$$0(1);
        }
        if (command == null) {
            ComposerActionStatistics.$$$reportNull$$$0(2);
        }
        return new ComposerActionStatistics(action, place, command, commandLineOptions);
    }

    public static ComposerActionStatistics createWithoutOptions(@NotNull String action, @NotNull String place) {
        if (action == null) {
            ComposerActionStatistics.$$$reportNull$$$0(3);
        }
        if (place == null) {
            ComposerActionStatistics.$$$reportNull$$$0(4);
        }
        return new ComposerActionStatistics(action, place, null, null);
    }

    private ComposerActionStatistics(@NotNull String action, @NotNull String place, @Nullable ComposerOptionsManager.Command command, @Nullable String commandLineOptions) {
        if (action == null) {
            ComposerActionStatistics.$$$reportNull$$$0(5);
        }
        if (place == null) {
            ComposerActionStatistics.$$$reportNull$$$0(6);
        }
        this.action = action;
        this.place = place;
        this.commandLineOptions = commandLineOptions;
        this.command = command;
    }

    public void report(@NotNull Project project) {
        if (project == null) {
            ComposerActionStatistics.$$$reportNull$$$0(7);
        }
        assert (!this.isReported);
        ComposerActionStatistics.reportAction(this.action, this.place, project);
        if (this.command != null) {
            List<String> options = ComposerActionStatistics.parse(this.commandLineOptions);
            List<String> defaultOptions = ComposerActionStatistics.parse(this.command.getDefaultValue());
            StringBuilder builder = new StringBuilder();
            builder.append(this.action).append("_with");
            for (String option : options) {
                if (!option.startsWith("-")) continue;
                builder.append("_").append(ComposerActionStatistics.adapt(option));
            }
            if (options.equals(defaultOptions)) {
                builder.append(".default");
            }
            String feature = builder.toString();
            FUSProjectUsageTrigger.getInstance((Project)project).trigger(ComposerCommandOptionsUsageCollector.class, feature);
        }
        this.isReported = true;
    }

    private static String adapt(String option) {
        char c;
        int i;
        for (i = 0; i < option.length() && ((c = option.charAt(i)) == '-' || Character.isLetterOrDigit(c)); ++i) {
        }
        if (i == 0) {
            return "Unknown";
        }
        return option.substring(0, i);
    }

    private static List<String> parse(@Nullable String options) {
        if (StringUtil.isEmptyOrSpaces((String)options)) {
            return Collections.emptyList();
        }
        List strings = StringUtil.splitHonorQuotes((String)options, (char)' ');
        strings.removeIf(option -> !option.startsWith("-"));
        Collections.sort(strings);
        return strings;
    }

    public static void reportAction(@NotNull String action, @NotNull String place, @NotNull Project project) {
        if (action == null) {
            ComposerActionStatistics.$$$reportNull$$$0(8);
        }
        if (place == null) {
            ComposerActionStatistics.$$$reportNull$$$0(9);
        }
        if (project == null) {
            ComposerActionStatistics.$$$reportNull$$$0(10);
        }
        String feature = action + "_from_" + place;
        FUSProjectUsageTrigger.getInstance((Project)project).trigger(ComposerActionUsageCollector.class, feature);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/statistics/ComposerActionStatistics";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createWithoutOptions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "reportAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

