/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class PhpDivisionByZeroInspection
extends PhpInspection {
    private static final int MAX_NUMBER_OF_CHARS_TO_PARSE = 10;
    private static final Pattern INTEGER = Pattern.compile("[+-]?(0x|0b)?0{1,10}");
    private static final Pattern FLOAT = Pattern.compile("[+-]?0{1,10}\\.0{1,10}");
    private static final int DELAY = 1000;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDivisionByZeroInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                PsiElement rightOperand;
                IElementType operationType = expression.getOperationType();
                if ((PhpTokenTypes.opDIV.equals(operationType) || PhpTokenTypes.opREM.equals(operationType)) && (rightOperand = expression.getRightOperand()) != null && rightOperand.getTextRange().getLength() < 10 && PhpDivisionByZeroInspection.isZero(rightOperand)) {
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.division.by.zero", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpDivisionByZeroInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    public static boolean isZero(@NotNull PsiElement element) {
        ASTNode childNode;
        ASTNode elementNode;
        IElementType elementType;
        if (element == null) {
            PhpDivisionByZeroInspection.$$$reportNull$$$0(2);
        }
        if ((elementType = (elementNode = element.getNode()).getElementType()) == PhpElementTypes.INFIX_EXPRESSION) {
            PsiElement temp = element.getLastChild();
            if (temp == null) {
                return false;
            }
            elementNode = temp.getNode();
            elementType = elementNode.getElementType();
        }
        if ((childNode = elementNode.getFirstChildNode()) != null) {
            IElementType childNodeType = childNode.getElementType();
            if (PhpElementTypes.NUMBER == elementType) {
                return PhpDivisionByZeroInspection.isZeroRegexp(elementNode.getText());
            }
            if (PhpElementTypes.STRING == elementType && (PhpTokenTypes.chLDOUBLE_QUOTE == childNodeType || PhpTokenTypes.chLSINGLE_QUOTE == childNodeType)) {
                childNode = childNode.getTreeNext();
                String childNodeString = childNode.getText();
                return PhpDivisionByZeroInspection.isZeroRegexp(childNodeString);
            }
        }
        return PhpElementTypes.CONSTANT_REF == elementType && element instanceof ConstantReference && PhpLangUtil.isFalse((ConstantReference)element);
    }

    public static boolean isZeroRegexp(String arg) {
        return INTEGER.matcher(StringUtil.newBombedCharSequence((CharSequence)arg, (long)1000L)).matches() || FLOAT.matcher(StringUtil.newBombedCharSequence((CharSequence)arg, (long)1000L)).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDivisionByZeroInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDivisionByZeroInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isZero";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

