/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsEdit;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class EditorInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvsoperations.cvsEdit.EditorInfo");
    public static final SyncDateFormat DATE_FORMAT;
    public static final SyncDateFormat DATE_FORMAT1;
    private final String myFilePath;
    private final String myUserName;
    private final Date myEditDate;
    private final String myHostName;
    private final String myPath;

    public static EditorInfo createOn(String string) {
        String[] strings = string.split("\t");
        if (strings.length != 5) {
            return null;
        }
        return new EditorInfo(strings[0], strings[1], EditorInfo.parse(strings[2]), strings[3], strings[4]);
    }

    private EditorInfo(String filePath, String userName, Date editDate, String hostName, String path) {
        this.myFilePath = filePath;
        this.myUserName = userName;
        this.myEditDate = editDate;
        this.myHostName = hostName;
        this.myPath = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EditorInfo)) {
            return false;
        }
        EditorInfo editorInfo = (EditorInfo)o;
        if (!this.myEditDate.equals(editorInfo.myEditDate)) {
            return false;
        }
        if (!this.myHostName.equals(editorInfo.myHostName)) {
            return false;
        }
        if (!this.myPath.equals(editorInfo.myPath)) {
            return false;
        }
        return this.myUserName.equals(editorInfo.myUserName);
    }

    public int hashCode() {
        int result = this.myUserName.hashCode();
        result = 29 * result + this.myEditDate.hashCode();
        result = 29 * result + this.myHostName.hashCode();
        result = 29 * result + this.myPath.hashCode();
        return result;
    }

    public String toString() {
        return this.myUserName + '\t' + DATE_FORMAT.format(this.myEditDate) + '\t' + this.myHostName + '\t' + this.myPath + '\t';
    }

    public String getUserName() {
        return this.myUserName;
    }

    public String getHostName() {
        return this.myHostName;
    }

    public String getPath() {
        return this.myPath;
    }

    public Date getEditDate() {
        return this.myEditDate;
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    private static Date parse(String s) {
        try {
            return DATE_FORMAT.parse(s);
        }
        catch (ParseException e) {
            try {
                return DATE_FORMAT1.parse(s);
            }
            catch (ParseException e1) {
                LOG.error((Throwable)e1);
                return new Date();
            }
        }
    }

    static {
        SimpleDateFormat delegate = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy zzz", Locale.US);
        delegate.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_FORMAT = new SyncDateFormat((DateFormat)delegate);
        SimpleDateFormat delegate1 = new SimpleDateFormat("dd MMM yyyy HH:mm:ss zzz", Locale.US);
        delegate1.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_FORMAT1 = new SyncDateFormat((DateFormat)delegate1);
    }
}

