/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptDelegatingMethodsUtil;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeEvaluationFunction;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFunctionSignatureChecker
extends JSElementVisitor {
    protected final JSTypeChecker myTypeChecker;

    public JSFunctionSignatureChecker(@NotNull JSTypeChecker typeChecker) {
        if (typeChecker == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(0);
        }
        this.myTypeChecker = typeChecker;
    }

    protected abstract void registerProblem(JSCallExpression var1, String var2, LocalQuickFix ... var3);

    public final void checkFunction(@NotNull JSCallExpression node, @NotNull PsiElement element) {
        PsiElement targetElement;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(2);
        }
        if (JSClassUtils.canHaveClasses(element) && (targetElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element)) instanceof JSClass) {
            this.checkConstructorCall(node, (JSClass)targetElement);
            return;
        }
        this.checkFunctionInternal(node, element, LocalQuickFix.EMPTY_ARRAY);
    }

    protected void checkFunctionInternal(@NotNull JSCallExpression node, @NotNull PsiElement element, LocalQuickFix[] quickFixes) {
        JSFunctionItem functionItem;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(4);
        }
        if ((functionItem = JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)node, false)) != null) {
            JSType returnType;
            if (!functionItem.isGetProperty() || (returnType = functionItem.getReturnType()) == null || !this.isCallableType(node instanceof JSNewExpression, returnType, (PsiElement)node)) {
                this.checkCallParameters(node, (PsiElement)functionItem, quickFixes);
            }
        } else {
            JSExpression methodExpression;
            JSType jsType = JSTypeUtils.getTypeOfElement(element);
            if (element instanceof JSFieldVariable && (methodExpression = node.getMethodExpression()) instanceof JSReferenceExpression) {
                jsType = JSTypeEvaluator.getTypeFromTypeGuard(element, (JSReferenceExpression)methodExpression, jsType, element);
            }
            this.canBeCalledWithArguments(jsType, node, quickFixes);
        }
    }

    protected void checkConstructorCall(@NotNull JSCallExpression node, @NotNull JSClass target) {
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(5);
        }
        if (target == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(6);
        }
        if (!(node instanceof JSNewExpression) && !(node.getMethodExpression() instanceof JSSuperExpression)) {
            return;
        }
        ResolveResult[] results = JSClassUtils.resolveES6Constructor(target, node.getMethodExpression());
        PsiElement resolveResultElement = JSResolveResult.resolveAny(results);
        LocalQuickFix createConstructorFix = JSFixFactory.getInstance().createConstructorFix(node, target);
        if (resolveResultElement instanceof JSFunction) {
            LocalQuickFix[] localQuickFixArray;
            if (JSResolveUtil.getClassOfContext(resolveResultElement) != target) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = createConstructorFix;
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] quickFixes = localQuickFixArray;
            this.checkFunctionInternal(node, resolveResultElement, quickFixes);
            return;
        }
        if (node.getArguments().length > 0) {
            this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{0}), createConstructorFix);
        }
    }

    public void reportProblemIfNotExpectedCountOfParameters(JSCallExpression node, int count, String n) {
        if (node.getArguments().length != count) {
            this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{n}), new LocalQuickFix[0]);
        }
    }

    protected boolean isCallableType(boolean inNewExpression, @NotNull JSType type, PsiElement context) {
        if (type == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(7);
        }
        return JSTypeUtils.hasFunctionType(type, inNewExpression, context);
    }

    protected void canBeCalledWithArguments(@Nullable JSType type, @NotNull JSCallExpression node, @NotNull LocalQuickFix[] quickFixes) {
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(8);
        }
        if (quickFixes == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(9);
        }
        if ((type = JSTypeUtils.getValuableType(type)) == null) {
            return;
        }
        if (!type.isTypeScript()) {
            this.canBeCalledWithArgumentsSingle(type, node, quickFixes);
            return;
        }
        List<Object> candidates = JSTypeUtils.getFunctionType(type, node instanceof JSNewExpression, (PsiElement)node).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            if (DialectDetector.isTypeScript((PsiElement)node)) {
                this.registerProblem(node, JSBundle.message((String)"javascript.argument.types.mismatch", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
            return;
        }
        if (candidates.size() > 1) {
            candidates = JSTypeUtils.chooseOverloadFunctionTypes(candidates, node);
        }
        if (candidates.size() == 1) {
            this.canBeCalledWithArgumentsSingle((JSType)candidates.get(0), node, quickFixes);
            return;
        }
        if (!JSTypeCastUtil.isAlwaysAssignableType(type, (PsiElement)node)) {
            this.registerProblem(node, JSBundle.message((String)"javascript.argument.types.mismatch", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
    }

    protected final void canBeCalledWithArgumentsSingle(@Nullable JSType type, @NotNull JSCallExpression node, @NotNull LocalQuickFix[] quickFixes) {
        JSParameterTypeDecorator nextDecorator;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(10);
        }
        if (quickFixes == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(11);
        }
        if (!((type = JSTypeUtils.getValuableType(type)) instanceof JSFunctionTypeImpl)) {
            return;
        }
        JSExpression[] arguments = node.getArguments();
        List<JSParameterTypeDecorator> parameters = ((JSFunctionTypeImpl)type).getParameters();
        Iterator<JSParameterTypeDecorator> myIterator = parameters.iterator();
        JSType restType = null;
        ProcessingContext context = JSTypeComparingContextService.getProcessingContextWithCallEnvironment((PsiElement)node);
        int restShift = 0;
        for (JSExpression argument : arguments) {
            JSType next;
            JSParameterTypeDecorator nextDecorator2 = null;
            if (restType != null) {
                next = restType;
            } else if (myIterator.hasNext()) {
                nextDecorator2 = myIterator.next();
                next = nextDecorator2.getTypeWithOptional();
            } else {
                this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{parameters.size()}), quickFixes);
                break;
            }
            if (nextDecorator2 != null && nextDecorator2.isRest()) {
                restType = nextDecorator2.getType();
            }
            if (restType instanceof JSTupleType) {
                if (((JSTupleType)restType).hasTypeByIndex(restShift)) {
                    next = ((JSTupleType)restType).getTypeByIndex(restShift);
                    ++restShift;
                } else {
                    int size = parameters.size();
                    String fromTo = "from " + (size - 1);
                    int tupleMax = ((JSTupleType)restType).getMaxLength();
                    if (tupleMax != Integer.MAX_VALUE) {
                        int maxCount = size + tupleMax - 1;
                        fromTo = maxCount == size - 1 ? String.valueOf(maxCount) : fromTo + " up to " + maxCount;
                    }
                    this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{fromTo}), quickFixes);
                    break;
                }
            }
            this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError(argument, next, null, "javascript.argument.type.mismatch", null, context, false);
        }
        if (myIterator.hasNext() && !(nextDecorator = myIterator.next()).isOptional() && !nextDecorator.isRest()) {
            this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{parameters.size()}), quickFixes);
        }
    }

    protected void checkCallParameters(@NotNull JSCallExpression node, @Nullable PsiElement element, LocalQuickFix[] quickFixes) {
        boolean matchFound;
        int[] initialMatchedParams;
        JSFunctionItem function;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(12);
        }
        JSFunctionItem jSFunctionItem = function = element != null ? JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)node.getMethodExpression(), false) : null;
        if (function == null) {
            return;
        }
        JSParameterItem[] parameters = function.getParameters();
        JSArgumentList argumentList = node.getArgumentList();
        if (PsiTreeUtil.getChildrenOfType((PsiElement)argumentList, OuterLanguageElement.class) != null) {
            return;
        }
        JSExpression[] expressions = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
        DefaultReporter reporter = this.createReporter((JSExpression)node);
        JSGenericTypeEvaluationFunction genericEvaluationFunction = JSGenericTypesEvaluator.getEvaluator((PsiElement)node).getEvaluationFunction(node.getMethodExpression(), (PsiElement)function, new JSGenericTypesEvaluator.GenericEvaluationContext(reporter));
        if (!(function.isReferencesArguments() || function instanceof JSImplicitElement && parameters.length == 0 && function.getReturnType() == null)) {
            Trinity<Integer, Integer, Boolean> minMaxParameters = ValidateTypesUtil.getMinMaxParameters(parameters);
            if (expressions.length < (Integer)minMaxParameters.first || expressions.length > (Integer)minMaxParameters.second) {
                String s;
                String string = (Boolean)minMaxParameters.third != false ? minMaxParameters.first + " or more" : (s = minMaxParameters.first + (!((Integer)minMaxParameters.first).equals(minMaxParameters.second) ? ".." + minMaxParameters.second : ""));
                if (function instanceof JSFunction) {
                    ArrayList fixes = ContainerUtil.newArrayListWithCapacity((int)2);
                    fixes.add(JSFixFactory.getInstance().changeSignatureFix((JSFunction)function, argumentList));
                    TypeScriptDelegatingMethodsUtil.processDelegationCandidates(node, (methodExpression, container, candidateFunction, parameterList, candidateFunctionParameterList) -> {
                        Ref invertedOrder;
                        JSFunction from;
                        if (node == null) {
                            JSFunctionSignatureChecker.$$$reportNull$$$0(27);
                        }
                        if ((from = TypeScriptDelegatingMethodsUtil.getMethodToTakeParametersFrom(methodExpression, container, candidateFunction, parameterList, candidateFunctionParameterList, (Ref<? super Boolean>)(invertedOrder = Ref.create((Object)false)), true)) != null) {
                            fixes.add(JSFixFactory.getInstance().changeSignatureWithDelegationUpdateFix(container, from, node));
                        }
                    }, true);
                    quickFixes = (LocalQuickFix[])ArrayUtil.mergeArrayAndCollection((Object[])quickFixes, (Collection)fixes, LocalQuickFix[]::new);
                }
                if (expressions.length == 1 && "window".equalsIgnoreCase(expressions[0].getText()) && parameters.length == 2) {
                    return;
                }
                if (argumentList != null && argumentList.hasSpreadElement() && expressions.length < (Integer)minMaxParameters.first) {
                    return;
                }
                this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{s}), quickFixes);
                return;
            }
        }
        if (!JSFunctionSignatureChecker.tryMakeInitialMatch(initialMatchedParams = new int[expressions.length], 0, 0, parameters)) {
            int paramWithMissedArgument;
            int arg = 0;
            for (paramWithMissedArgument = 0; paramWithMissedArgument < parameters.length; ++paramWithMissedArgument) {
                if (parameters[paramWithMissedArgument].isOptional() || parameters[paramWithMissedArgument].getType() == null) continue;
                if (arg >= expressions.length) break;
                ++arg;
            }
            if (paramWithMissedArgument < parameters.length) {
                this.registerProblem(node, JSBundle.message((String)"javascript.missed.argument.for.parameter", (Object[])new Object[]{parameters[paramWithMissedArgument].getName()}), quickFixes);
            }
            return;
        }
        int[] matchedParams = new int[initialMatchedParams.length];
        System.arraycopy(initialMatchedParams, 0, matchedParams, 0, matchedParams.length);
        boolean first = true;
        ProcessingContext context = JSTypeComparingContextService.getProcessingContextWithCallEnvironment((PsiElement)node);
        block1: do {
            if (first) {
                int[] _matchedParams = new int[matchedParams.length];
                System.arraycopy(matchedParams, 0, _matchedParams, 0, matchedParams.length);
                if (!this.obtainNextMatchedParams(_matchedParams, parameters) || JSFunctionSignatureChecker.useOnlyFirstMatch(function)) {
                    matchFound = false;
                    break;
                }
                first = false;
            }
            matchFound = true;
            for (int argIndex = 0; argIndex < expressions.length; ++argIndex) {
                JSParameterItem p = parameters[matchedParams[argIndex]];
                JSType parameterType = p.getTypeWithOptional();
                JSType modifiedType = this.modifyParameterTypeFromCall(parameterType, p, genericEvaluationFunction, node, p.isRest(), argIndex, parameters.length);
                if (JSResolveUtil.isAssignableJSType(modifiedType, JSResolveUtil.getExpressionJSType(expressions[argIndex]), context)) continue;
                matchFound = false;
                continue block1;
            }
        } while (!matchFound && this.obtainNextMatchedParams(matchedParams, parameters));
        if (matchFound) {
            return;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)node);
        int paramIndex = -1;
        boolean errorReported = false;
        for (int argIndex = 0; argIndex < expressions.length && ++paramIndex < initialMatchedParams.length; ++argIndex) {
            JSParameterItem curParameter = parameters[initialMatchedParams[paramIndex]];
            JSExpression expression = expressions[argIndex];
            if (curParameter.isRest()) {
                if (dialect == DialectOptionHolder.ECMA_4) break;
                JSType type = curParameter.getTypeWithOptional();
                if (expression instanceof JSSpreadExpression) {
                    paramIndex = this.validateSpread(node, curParameter, parameters, context, paramIndex, (JSSpreadExpression)expression, type, genericEvaluationFunction);
                    continue;
                }
                JSType modified = this.modifyParameterTypeFromCall(type, curParameter, genericEvaluationFunction, node, true, argIndex, parameters.length);
                errorReported |= !this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError(expression, modified, null, "javascript.argument.type.mismatch", null, context, false);
                continue;
            }
            errorReported |= !this.checkCallArgumentType(curParameter, expression, node, context, genericEvaluationFunction);
        }
        if (!errorReported) {
            reporter.reportGenericErrorIfExist();
        }
    }

    private int validateSpread(@NotNull JSCallExpression node, @NotNull JSParameterItem parameterItem, @NotNull JSParameterItem[] parameters, @NotNull ProcessingContext context, int paramIndex, @NotNull JSSpreadExpression expression, JSType type, JSGenericTypeEvaluationFunction genericEvaluationFunction) {
        JSType expressionType;
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(13);
        }
        if (parameterItem == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(14);
        }
        if (parameters == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(15);
        }
        if (context == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(16);
        }
        if (expression == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(17);
        }
        if ((expressionType = JSResolveUtil.getExpressionJSType(expression.getExpression())) instanceof JSTupleType) {
            JSTupleType tupleType = (JSTupleType)expressionType;
            if (tupleType.getMaxLength() != Integer.MAX_VALUE) {
                for (int i = 0; i < tupleType.getMaxLength(); ++i) {
                    this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError((JSExpression)expression, this.modifyParameterTypeFromCall(type, parameterItem, genericEvaluationFunction, node, true, paramIndex, parameters.length), null, "javascript.argument.type.mismatch", null, context, tupleType.getTypeByIndex(i));
                    ++paramIndex;
                }
            } else {
                List types = tupleType.getTypes();
                JSType item = (JSType)ContainerUtil.getLastItem((List)types);
                assert (item instanceof JSSpreadType);
                for (int i = 0; i < types.size() - 1; ++i) {
                    this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError((JSExpression)expression, this.modifyParameterTypeFromCall(type, parameterItem, genericEvaluationFunction, node, true, paramIndex, parameters.length), null, "javascript.argument.type.mismatch", null, context, tupleType.getTypeByIndex(i));
                    ++paramIndex;
                }
                this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError((JSExpression)expression, this.modifyParameterTypeFromCall(type, parameterItem, genericEvaluationFunction, node, true, paramIndex, parameters.length), null, "javascript.argument.type.mismatch", null, context, ((JSSpreadType)item).getComponentType());
            }
        } else if (expressionType != null) {
            this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError((JSExpression)expression, this.modifyParameterTypeFromCall(type, parameterItem, genericEvaluationFunction, node, true, paramIndex, parameters.length), null, "javascript.argument.type.mismatch", null, context, JSTypeUtils.getIndexableComponentType(expressionType));
        }
        return paramIndex;
    }

    private static boolean useOnlyFirstMatch(@NotNull JSFunctionItem function) {
        PsiFile file2;
        if (function == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(18);
        }
        VirtualFile virtualFile = (file2 = function.getContainingFile()) != null ? file2.getViewProvider().getVirtualFile() : null;
        return virtualFile != null && JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(virtualFile);
    }

    protected boolean obtainNextMatchedParams(int[] matchedParams, JSParameterItem[] parameters) {
        for (int argIndexToShift = matchedParams.length - 1; argIndexToShift >= 0; --argIndexToShift) {
            int paramOffset;
            int oldParamIndex;
            if (matchedParams[argIndexToShift] >= parameters.length - 1 || !parameters[oldParamIndex = matchedParams[argIndexToShift]].isOptional() && !parameters[oldParamIndex].getTypeDecorator().isRest()) continue;
            int newParamIndex = oldParamIndex + 1;
            int n = paramOffset = newParamIndex < parameters.length && parameters[newParamIndex].getTypeDecorator().isRest() ? newParamIndex : newParamIndex + 1;
            if (!JSFunctionSignatureChecker.tryMakeInitialMatch(matchedParams, argIndexToShift + 1, paramOffset, parameters)) continue;
            int n2 = argIndexToShift;
            matchedParams[n2] = matchedParams[n2] + 1;
            return true;
        }
        return false;
    }

    private static boolean tryMakeInitialMatch(int[] matchedParams, int matchedParamsOffset, int paramsOffset, JSParameterItem[] parameters) {
        boolean fits;
        if (matchedParamsOffset > matchedParams.length) {
            return false;
        }
        if (paramsOffset > parameters.length) {
            return false;
        }
        int argumentsToMatch = matchedParams.length - matchedParamsOffset;
        int required = 0;
        boolean hasRest = false;
        for (int i = paramsOffset; i < parameters.length; ++i) {
            if (parameters[i].getTypeDecorator().isRest()) {
                hasRest = true;
                continue;
            }
            if (parameters[i].isOptional()) continue;
            ++required;
        }
        boolean bl = fits = required <= argumentsToMatch && (hasRest || argumentsToMatch <= parameters.length - paramsOffset);
        if (!fits) {
            return false;
        }
        for (int i = matchedParamsOffset; i < matchedParams.length; ++i) {
            if (required == matchedParams.length - i) {
                while (parameters[paramsOffset].getTypeDecorator().isRest() || parameters[paramsOffset].isOptional()) {
                    ++paramsOffset;
                }
            }
            matchedParams[i] = paramsOffset;
            if (parameters[paramsOffset].getTypeDecorator().isRest()) continue;
            if (!parameters[paramsOffset].isOptional()) {
                --required;
            }
            ++paramsOffset;
        }
        return true;
    }

    @Nullable
    @Contract(value="!null, _, _, _, _, _, _ -> !null")
    protected final JSType modifyParameterTypeFromCall(@Nullable JSType type, JSParameterItem parameterItem, @NotNull JSGenericTypeEvaluationFunction genericEvaluationFunction, @NotNull JSCallExpression callExpression, boolean isRest, int argIndex, int signatureParameterCount) {
        if (genericEvaluationFunction == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(19);
        }
        if (callExpression == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(20);
        }
        JSType toProcess = genericEvaluationFunction.evaluate(type);
        if (isRest && toProcess instanceof JSTupleType && type != null && type.isEquivalentTo(parameterItem.getDeclaredType(), null)) {
            toProcess = this.verifyAndModifyByTuple((JSTupleType)toProcess, callExpression, argIndex, signatureParameterCount);
        }
        return toProcess;
    }

    @Nullable
    private JSType verifyAndModifyByTuple(@NotNull JSTupleType type, @NotNull JSCallExpression callExpression, int argIndex, int signatureParameterCount) {
        int restPosition;
        int tupleElement;
        if (type == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(21);
        }
        if (callExpression == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(22);
        }
        if (type.hasTypeByIndex(tupleElement = argIndex - (restPosition = signatureParameterCount - 1))) {
            return type.getTypeByIndex(tupleElement);
        }
        int maxLength = type.getMaxLength();
        String fromUpTo = maxLength != Integer.MAX_VALUE ? "from " + restPosition + " up to " + (signatureParameterCount + maxLength - 1) : restPosition + " or more";
        this.registerProblem(callExpression, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{fromUpTo}), new LocalQuickFix[0]);
        return type;
    }

    protected DefaultReporter createReporter(@Nullable JSExpression expression) {
        return new DefaultReporter(expression);
    }

    protected boolean checkCallArgumentType(@NotNull JSParameterItem p, @Nullable JSExpression expression, @NotNull JSCallExpression node, @NotNull ProcessingContext processingContext, @NotNull JSGenericTypeEvaluationFunction function) {
        if (p == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(23);
        }
        if (node == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(24);
        }
        if (processingContext == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(25);
        }
        if (function == null) {
            JSFunctionSignatureChecker.$$$reportNull$$$0(26);
        }
        return this.myTypeChecker.checkExpressionIsAssignableToTypeAndReportError(expression, function.evaluate(p.getTypeWithOptional()), null, "javascript.argument.type.mismatch", (PsiElement)(p instanceof JSParameter ? (JSParameter)p : null), processingContext, false);
    }

    protected boolean processMethodExpressionResolveResult(JSCallExpression callExpression, JSReferenceExpression methodExpression, PsiElement resolveResult, JSType type) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeChecker";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterItem";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericEvaluationFunction";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSFunctionSignatureChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunctionInternal";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConstructorCall";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallableType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeCalledWithArguments";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeCalledWithArgumentsSingle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCallParameters";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "validateSpread";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "useOnlyFirstMatch";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyParameterTypeFromCall";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "verifyAndModifyByTuple";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCallArgumentType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$checkCallParameters$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class DefaultReporter
    implements JSGenericTypesEvaluator.GenericErrorReporter {
        @Nullable
        private final JSExpression myExpression;
        public String myMessage = null;

        public DefaultReporter(JSExpression expression) {
            this.myExpression = expression;
        }

        @Override
        public void error(@NotNull String parameter) {
            if (parameter == null) {
                DefaultReporter.$$$reportNull$$$0(0);
            }
            if (this.myMessage != null) {
                return;
            }
            this.myMessage = parameter;
        }

        public void reportGenericErrorIfExist() {
            if (this.myMessage != null && this.myExpression != null && DialectDetector.isTypeScript((PsiElement)this.myExpression)) {
                JSFunctionSignatureChecker.this.myTypeChecker.registerProblem((PsiElement)this.myExpression, JSBundle.message((String)this.myMessage, (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)this.myExpression), new LocalQuickFix[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/validation/JSFunctionSignatureChecker$DefaultReporter", "error"));
        }
    }
}

