/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.performancePlugin.LabelsBundle;
import com.jetbrains.performancePlugin.profilers.AsyncProfilerHandler;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAsyncRunParametersDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private RawCommandLineEditor myAsyncProfilerParameters;
    private JBLabel myInfoJBLabel;
    private final Project myProject;
    private final AsyncProfilerHandler asyncProfiler;

    public ConfigureAsyncRunParametersDialog(@NotNull Project project) {
        if (project == null) {
            ConfigureAsyncRunParametersDialog.$$$reportNull$$$0(0);
        }
        super(project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(LabelsBundle.message("async.profiler.parameters.title", objectArray));
        this.myProject = project;
        this.asyncProfiler = AsyncProfilerHandler.getInstance(this.myProject);
        this.myInfoJBLabel.setText(String.format(LabelsBundle.message("async.profiler.parameters.help.text", new Object[0]), this.asyncProfiler.isProfilingStarted() ? "stop" : "start"));
        this.myAsyncProfilerParameters.setText(this.asyncProfiler.isProfilingStarted() ? "flat=1000,svg,collapsed,traces=5000,summary" : "jfr,interval=10000000");
        this.myInfoJBLabel.setLabelFor((Component)this.myAsyncProfilerParameters);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @NotNull
    protected Action[] createActions() {
        DialogWrapper.DialogWrapperAction execute = new DialogWrapper.DialogWrapperAction(this.asyncProfiler.isProfilingStarted() ? "&Stop" : "&Start"){

            protected void doAction(ActionEvent e) {
                List<String> parameters = Arrays.asList(ConfigureAsyncRunParametersDialog.this.myAsyncProfilerParameters.getText().trim().split(","));
                ActionCallbackProfilerStopper myActionCallback = new ActionCallbackProfilerStopper(ConfigureAsyncRunParametersDialog.this.myProject);
                ConfigureAsyncRunParametersDialog.this.doOKAction();
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (ConfigureAsyncRunParametersDialog.this.myProject != null) {
                        try {
                            if (ConfigureAsyncRunParametersDialog.this.asyncProfiler.isProfilingStarted()) {
                                ConfigureAsyncRunParametersDialog.this.asyncProfiler.stopProfiling(parameters);
                                ConfigureAsyncRunParametersDialog.this.asyncProfiler.showCompleteNotification();
                            } else {
                                ConfigureAsyncRunParametersDialog.this.asyncProfiler.startProfiling("UserActivity", parameters);
                            }
                        }
                        catch (Exception exception) {
                            myActionCallback.reject(exception.getMessage());
                        }
                    }
                });
            }
        };
        Action[] actionArray = new Action[]{execute, this.getCancelAction()};
        if (actionArray == null) {
            ConfigureAsyncRunParametersDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/ui/ConfigureAsyncRunParametersDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/ui/ConfigureAsyncRunParametersDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myAsyncProfilerParameters = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myInfoJBLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("Labels").getString("input.below.parameters.for.async.profiler"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)rawCommandLineEditor);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

