/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.vcs.FileStatus;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TextFilePatch
extends FilePatch {
    private final Charset myCharset;
    @Nullable
    private final String myLineSeparator;
    private final List<PatchHunk> myHunks;
    @Nullable
    private FileStatus myFileStatus;

    public TextFilePatch(@Nullable Charset charset) {
        this(charset, null);
    }

    public TextFilePatch(@Nullable Charset charset, @Nullable String lineSeparator) {
        this.myCharset = charset;
        this.myLineSeparator = lineSeparator;
        this.myHunks = new ArrayList<PatchHunk>();
    }

    public TextFilePatch pathsOnlyCopy() {
        return new TextFilePatch(this);
    }

    private TextFilePatch(TextFilePatch patch) {
        this.myCharset = patch.myCharset;
        this.setBeforeVersionId(patch.getBeforeVersionId());
        this.setAfterVersionId(patch.getAfterVersionId());
        this.setBeforeName(patch.getBeforeName());
        this.setAfterName(patch.getAfterName());
        this.myHunks = patch.myHunks;
        this.myLineSeparator = patch.getLineSeparator();
        this.setNewFileMode(patch.getNewFileMode());
        this.setFileStatus(patch.myFileStatus);
    }

    public void addHunk(PatchHunk hunk) {
        this.myHunks.add(hunk);
    }

    public List<PatchHunk> getHunks() {
        return Collections.unmodifiableList(this.myHunks);
    }

    @Override
    public boolean isNewFile() {
        return this.myFileStatus == FileStatus.ADDED || this.myHunks.size() == 1 && this.myHunks.get(0).isNewContent();
    }

    public String getSingleHunkPatchText() {
        if (this.myHunks.isEmpty()) {
            return "";
        }
        assert (this.myHunks.size() == 1);
        return this.myHunks.get(0).getText();
    }

    @Override
    public boolean isDeletedFile() {
        return this.myFileStatus == FileStatus.DELETED || this.myHunks.size() == 1 && this.myHunks.get(0).isDeletedContent();
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    @Nullable
    public String getLineSeparator() {
        return this.myLineSeparator;
    }

    public void setFileStatus(@Nullable FileStatus fileStatus) {
        this.myFileStatus = fileStatus;
    }
}

