/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.PgNumber2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class PostgresBaseDomains
extends DomainRegistry {
    public static final int MAX_FRACTION = 6;
    public static final double MAX_REAL = 1.0E37;
    public static final double MIN_REAL = -1.0E37;
    public static final double MIN_DOUBLE = -1.0E307;
    public static final double MAX_DOUBLE = 1.0E308;

    protected PostgresBaseDomains(int maxPrecision, int maxScale, int maxChar, int maxVarchar) {
        this.add(new PgNumber2Domain("numeric", ConversionPoint.BIG_DECIMAL, maxPrecision, maxScale, true));
        this.add(new PgNumber2Domain("decimal", ConversionPoint.BIG_DECIMAL, maxPrecision, maxScale, true));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("int4", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("int2", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("int8", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add(new FloatDomain("float8", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -1.0E37, 1.0E37));
        this.add(new FloatDomain("float4", ConversionPoint.SINGLE_PRECISION, -1.0E37, 1.0E37));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add(new TextDomain("char", ConversionPoint.CHAR, maxChar, 1L, true));
        this.add(new TextDomain("bpchar", ConversionPoint.CHAR, maxChar, 1L, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, maxChar, 1L, true));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, maxVarchar, -1L, true));
        this.add(new TextDomain("character varying", ConversionPoint.VARCHAR, maxVarchar, -1L, true));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add(new BooleanDomain("bool", ConversionPoint.BOOLEAN));
    }

    protected static class MyZonedDomain
    extends FractionDomain {
        private final String myPrefix;

        public MyZonedDomain(@NotNull FractionDomain domain, @NotNull String prefix) {
            if (domain == null) {
                MyZonedDomain.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                MyZonedDomain.$$$reportNull$$$0(1);
            }
            super(domain.simpleName(), domain.getPoint(), domain.getDomainType(), domain.getMax(), domain.getDefaultValue(), domain.isNarrowable());
            this.myPrefix = prefix;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                MyZonedDomain.$$$reportNull$$$0(2);
            }
            MyZonedDomain myZonedDomain = new MyZonedDomain((FractionDomain)super.narrow(domain), this.myPrefix);
            if (myZonedDomain == null) {
                MyZonedDomain.$$$reportNull$$$0(3);
            }
            return myZonedDomain;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                MyZonedDomain.$$$reportNull$$$0(4);
            }
            MyZonedDomain myZonedDomain = new MyZonedDomain((FractionDomain)super.narrow(provider), this.myPrefix);
            if (myZonedDomain == null) {
                MyZonedDomain.$$$reportNull$$$0(5);
            }
            return myZonedDomain;
        }

        @Override
        @NotNull
        public String name() {
            String string = this.shouldParametrize() ? StringUtil.toUpperCase((String)this.myPrefix) + "(" + this.getMax() + ") WITH TIME ZONE" : super.name();
            if (string == null) {
                MyZonedDomain.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/postgresbase/PostgresBaseDomains$MyZonedDomain";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/postgresbase/PostgresBaseDomains$MyZonedDomain";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "narrow";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "narrow";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

