/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem.util;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.VersionComparatorUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.cli.RMInspectionToolLaunchSettings;
import org.jetbrains.plugins.ruby.gem.GemCallTypeProvider;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.bundler.BundleExecSettings;
import org.jetbrains.plugins.ruby.gem.detector.GemDetector;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsChangeWatcher;
import org.jetbrains.plugins.ruby.gem.ui.GemUiUtil;
import org.jetbrains.plugins.ruby.gem.util.GemEnvironment;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebugMode;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.run.CmdlinePreprocessor;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.sdk.LocalRubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.utils.OSUtil;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class BundlerUtil {
    public static final String BUNDLER = "bundler";
    public static final String BUNDLE = "bundle";
    private static final String a = "bundle.bat";
    private static final String q = "Gemfile";
    private static final String j = "Gemfile.lock";
    private static final String r = "gems.rb";
    private static final String n = "gems.locked";
    private static final String[] o;
    public static final String CONFIG_FILE_NAME = "config";
    public static final String RBUNDLER_SETUP = "-rbundler/setup";
    public static final String BUNDLER_HTTP_PROXY_ENV_VAR = "HTTP_PROXY";
    private static final Logger e;
    private static final String m = ".bundle";
    private static final String l;
    private static final String d = ".bundler";
    private static final Pattern g;
    private static final Pattern k;
    private static final String p = "/bundler/gems";
    private static final String f = "/";
    private static final String h = "group";
    @NonNls
    private static final String b = "test/unit/ui/teamcity/loadpath_patch.rb";
    private static final String c = "BUNDLE_BIN_PATH";
    private static final String i = "BUNDLE_GEMFILE";
    private static final long s;

    private BundlerUtil() {
    }

    public static void addBundlerBinPaths(Module module, List<String> binaryScriptsLookupFolders) {
        if (module == null || module.isDisposed()) {
            return;
        }
        BundlerUtil.a(BundlerUtil.getBundlerGemsDirFromConfig(module), binaryScriptsLookupFolders);
        for (VirtualFile virtualFile : BundlerUtil.b(module)) {
            BundlerUtil.a(virtualFile, binaryScriptsLookupFolders);
        }
    }

    public static void openGemFileInEditor(@NotNull Project project, @NotNull String rootPath) {
        long l2 = s ^ 0x6ED0C8E23653L;
        if (project == null) {
            BundlerUtil.a(0);
        }
        if (rootPath == null) {
            BundlerUtil.a(1);
        }
        GeneratorsUtil.openFileInEditor(project, new File(rootPath, q).exists() ? q : r, rootPath);
    }

    private static void a(@Nullable VirtualFile virtualFile, @NotNull List<String> list2) {
        long l2 = s ^ 0x1EA5F3C3DE06L;
        if (list2 == null) {
            BundlerUtil.a(2);
        }
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile.findChild("bin");
        if (virtualFile2 != null) {
            list2.add(virtualFile2.getPath());
        }
    }

    public static boolean installBundler(@Nullable Module module, @Nullable Sdk sdk) {
        long l2 = s ^ 0x2C4D3DA7DA6CL;
        if (sdk == null && (sdk = RModuleUtil.getInstance().findRubySdkForModule(module)) == null) {
            return false;
        }
        THashMap tHashMap = new THashMap();
        GemInstallUtil.installGemsDependencies(sdk, module, Collections.singleton(GemDependency.any(BUNDLER)), true, false, (Map<GemDependency, String>)tHashMap);
        if (!tHashMap.isEmpty()) {
            GemUiUtil.showInstallErrors(module, (Map<GemDependency, String>)tHashMap);
            return false;
        }
        return true;
    }

    public static boolean hasGemfile(@Nullable Module module) {
        return BundlerUtil.getGemfile(module) != null;
    }

    @Nullable
    public static RFile getGemfilePsiFile(@Nullable Module module) {
        return (RFile)ReadAction.compute(() -> {
            if (module == null || module.isDisposed()) {
                return null;
            }
            VirtualFile virtualFile = BundlerUtil.getGemfile(module);
            if (virtualFile == null) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile);
            return psiFile instanceof RFile ? (RFile)psiFile : null;
        });
    }

    private static VirtualFile[] b(Module module) {
        Object[] objectArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
        VirtualFile virtualFile = module.getModuleFile();
        if (objectArray.length > 1 && virtualFile != null) {
            for (int i10 = 0; i10 < objectArray.length; ++i10) {
                VirtualFile virtualFile2 = objectArray[i10];
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
                ArrayUtil.swap((Object[])objectArray, (int)0, (int)i10);
                break;
            }
        }
        return objectArray;
    }

    @Nullable
    public static VirtualFile getGemfile(@Nullable Module module) {
        return (VirtualFile)ReadAction.compute(() -> {
            if (RMInspectionToolLaunchSettings.getInstance().isActivated()) {
                return BundlerUtil.a();
            }
            return BundlerUtil.a(module, false, true, o);
        });
    }

    @Nullable
    private static VirtualFile a(@Nullable Module module, boolean bl2, boolean bl3, String ... stringArray) {
        if (stringArray == null) {
            BundlerUtil.a(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (module == null || module.isDisposed()) {
            return null;
        }
        for (VirtualFile virtualFile : BundlerUtil.b(module)) {
            if (bl2) {
                virtualFile.refresh(false, false);
            }
            for (String string : stringArray) {
                VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(FileUtil.toSystemIndependentName((String)string));
                if (virtualFile2 == null || !virtualFile2.isValid() || bl3 && ProjectFileIndex.getInstance((Project)module.getProject()).isExcluded(virtualFile2)) continue;
                return virtualFile2;
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile getGemfile(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            BundlerUtil.a(4);
        }
        if (root == null) {
            BundlerUtil.a(5);
        }
        if (!root.isValid() || !root.isDirectory()) {
            return null;
        }
        for (String string : o) {
            VirtualFile virtualFile = root.findChild(string);
            if (virtualFile == null || ProjectFileIndex.getInstance((Project)project).isExcluded(virtualFile)) continue;
            return virtualFile;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getGemfileLock(@Nullable Module module) {
        return (VirtualFile)ReadAction.compute(() -> BundlerUtil.a(module, false));
    }

    @Nullable
    public static VirtualFile getGemfileLockWithRefresh(@Nullable Module module) {
        return BundlerUtil.a(module, true);
    }

    @Nullable
    private static VirtualFile a(@Nullable Module module, boolean bl2) {
        if (RMInspectionToolLaunchSettings.getInstance().isActivated()) {
            return BundlerUtil.b();
        }
        VirtualFile virtualFile = BundlerUtil.getGemfile(module);
        if (virtualFile == null) {
            return null;
        }
        return BundlerUtil.a(module, bl2, true, BundlerUtil.a(virtualFile));
    }

    @NotNull
    private static String a(@NotNull VirtualFile virtualFile) {
        long l2 = s ^ 0x2AB8091C704L;
        if (virtualFile == null) {
            BundlerUtil.a(6);
        }
        String string = q.equalsIgnoreCase(virtualFile.getName()) ? j : n;
        if (string == null) {
            BundlerUtil.a(7);
        }
        return string;
    }

    @Nullable
    private static VirtualFile b() {
        VirtualFile virtualFile = BundlerUtil.a();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.getParent();
        return virtualFile2 == null || !virtualFile2.isValid() ? null : virtualFile2.findChild(BundlerUtil.a(virtualFile));
    }

    @Nullable
    public static VirtualFile getConfigFile(@Nullable Module module) {
        return BundlerUtil.a(module, false, false, l);
    }

    @Nullable
    private static VirtualFile c() {
        File file = new File(FileUtil.join((String[])new String[]{SystemProperties.getUserHome(), l}));
        return file.exists() ? VfsUtil.findFileByIoFile((File)file, (boolean)true) : null;
    }

    public static boolean isGemfile(@Nullable PsiFileSystemItem psiFileSystemItem) {
        return psiFileSystemItem != null && BundlerUtil.isGemfile(psiFileSystemItem.getProject(), psiFileSystemItem.getVirtualFile());
    }

    @Deprecated
    @Contract(value="null -> false")
    public static boolean isGemfile(@Nullable VirtualFile virtualFile) {
        return virtualFile != null && !virtualFile.isDirectory() && BundlerUtil.isGemfileName(virtualFile.getName());
    }

    @Contract(value="_, null -> false")
    public static boolean isGemfile(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            BundlerUtil.a(8);
        }
        return BundlerUtil.isGemfile(virtualFile) && !ProjectFileIndex.getInstance((Project)project).isExcluded(virtualFile);
    }

    public static boolean isGemfileName(@Nullable String fileName) {
        long l2 = s ^ 0x28683FF7E3FCL;
        return fileName != null && (q.equalsIgnoreCase(fileName) || r.equalsIgnoreCase(fileName));
    }

    public static boolean isGemfileLockName(@Nullable String fileName) {
        long l2 = s ^ 0x18D233340239L;
        return fileName != null && (j.equalsIgnoreCase(fileName) || n.equalsIgnoreCase(fileName));
    }

    public static boolean isBundlerCall(RCall rCall) {
        long l2 = s ^ 0x4331B63E3BA5L;
        for (PsiReference psiReference : rCall.getPsiCommand().getReferences()) {
            PsiElement psiElement = psiReference.resolve();
            if (!(psiElement instanceof RMethod)) continue;
            RContainer rContainer = ((RMethod)psiElement).getParentContainer();
            rContainer = rContainer != null ? rContainer.getParentContainer() : null;
            return rContainer != null && BUNDLER.equalsIgnoreCase(rContainer.getName());
        }
        return false;
    }

    @Nullable
    public static VirtualFile getGitGemSpec(VirtualFile gemDir) {
        long l2 = s ^ 0x37F733423453L;
        if (gemDir == null) {
            return null;
        }
        for (VirtualFile virtualFile : gemDir.getChildren()) {
            String string = virtualFile.getName();
            if (!string.endsWith(".gemspec") || string.startsWith(".")) continue;
            return virtualFile;
        }
        return null;
    }

    public static void addBundlerPaths(Sdk sdk, Set<String> result) {
        String string2;
        long l2 = s ^ 0x39D7B6DED98L;
        for (String string2 : ArrayUtil.toStringArray(result)) {
            result.add(string2.replaceAll("/gems$", p));
        }
        String string3 = SystemProperties.getUserHome();
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)string3));
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile.findChild(d);
        if (virtualFile2 == null) {
            virtualFile2 = virtualFile.findChild(m);
        }
        if (virtualFile2 == null) {
            return;
        }
        string2 = virtualFile2.findChild(BundlerUtil.getSdkTypeStr(sdk));
        if (string2 == null || !string2.isDirectory()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.getUrl());
        stringBuilder.append(f).append(BundlerUtil.getGemSdkVersion(sdk));
        result.add(stringBuilder.toString() + f + "gems");
        stringBuilder.append(f).append(BUNDLER);
        stringBuilder.append(f).append("gems");
        result.add(stringBuilder.toString());
    }

    @NotNull
    public static String getGemSdkVersion(@Nullable Sdk sdk) {
        long l2 = s ^ 0x2C5B8C6F6230L;
        if (RubySdkUtil.isRuby26(sdk)) {
            if ("2.6.0" == null) {
                BundlerUtil.a(9);
            }
            return "2.6.0";
        }
        if (RubySdkUtil.isRuby25(sdk)) {
            if ("2.5.0" == null) {
                BundlerUtil.a(10);
            }
            return "2.5.0";
        }
        if (RubySdkUtil.isRuby24(sdk)) {
            if ("2.4.0" == null) {
                BundlerUtil.a(11);
            }
            return "2.4.0";
        }
        if (RubySdkUtil.isRuby23(sdk)) {
            if ("2.3.0" == null) {
                BundlerUtil.a(12);
            }
            return "2.3.0";
        }
        if (RubySdkUtil.isRuby22(sdk)) {
            if ("2.2.0" == null) {
                BundlerUtil.a(13);
            }
            return "2.2.0";
        }
        if (RubySdkUtil.isRuby21(sdk)) {
            if ("2.1.0" == null) {
                BundlerUtil.a(14);
            }
            return "2.1.0";
        }
        if (RubySdkUtil.isRuby20(sdk)) {
            if ("2.0.0" == null) {
                BundlerUtil.a(15);
            }
            return "2.0.0";
        }
        if (RubySdkUtil.isRuby19(sdk)) {
            String string = JRubySdkUtil.isJRubySDK(sdk) ? "1.9" : "1.9.1";
            if (string == null) {
                BundlerUtil.a(16);
            }
            return string;
        }
        if ("1.8" == null) {
            BundlerUtil.a(17);
        }
        return "1.8";
    }

    @NotNull
    public static String getSdkTypeStr(@Nullable Sdk sdk) {
        long l2 = s ^ 0x50770181DD4AL;
        String string = JRubySdkUtil.isJRubySDK(sdk) ? "jruby" : "ruby";
        if (string == null) {
            BundlerUtil.a(18);
        }
        return string;
    }

    @Nullable
    public static VirtualFile getBundlerGemsDirFromConfig(@Nullable Module module) {
        return (VirtualFile)ReadAction.compute(() -> {
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            VirtualFile[] virtualFileArray = BundlerUtil.b(module);
            if (virtualFileArray.length == 0) {
                return null;
            }
            VirtualFile virtualFile = BundlerUtil.getConfigFile(module);
            VirtualFile virtualFile2 = virtualFile != null ? virtualFile.getParent().getParent() : virtualFileArray[0];
            VirtualFile virtualFile3 = BundlerUtil.a(sdk, virtualFile, virtualFile2);
            return virtualFile3 == null ? BundlerUtil.a(sdk, BundlerUtil.c(), virtualFile2) : virtualFile3;
        });
    }

    @Nullable
    private static VirtualFile a(@Nullable Sdk sdk, @Nullable VirtualFile virtualFile, VirtualFile virtualFile2) {
        VirtualFile virtualFile3 = BundlerUtil.getBundlePath(virtualFile, virtualFile2);
        return virtualFile3 != null ? BundlerUtil.a(sdk, virtualFile3.getPath()) : null;
    }

    @Nullable
    public static VirtualFile getBundlePath(@Nullable VirtualFile config, @NotNull VirtualFile root) {
        if (root == null) {
            BundlerUtil.a(19);
        }
        if (config == null) {
            return null;
        }
        try {
            String string = VfsUtilCore.loadText((VirtualFile)config);
            Matcher matcher = g.matcher(string);
            if (matcher.find()) {
                String string2 = StringUtil.unquoteString((String)matcher.group(1));
                VirtualFile virtualFile = root.findFileByRelativePath(string2);
                if (virtualFile == null && string2.startsWith("~")) {
                    virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)string2.replaceFirst("~", SystemProperties.getUserHome())));
                }
                if (virtualFile != null) {
                    return virtualFile;
                }
                return VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)string2));
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    @Nullable
    public static GemInfo getBundlerGem(@Nullable Sdk sdk, @Nullable Module module, boolean execution) {
        GemInfo gemInfo;
        long l2 = s ^ 0x7429E74DA399L;
        if (execution) {
            GemDependency gemDependency = GemDependency.create(BUNDLER, ">= 0.9");
            assert (gemDependency != null);
            gemInfo = GemSearchUtil.findGem(module, gemDependency);
            gemInfo = gemInfo == null ? GemSearchUtil.findGem(module, sdk, gemDependency) : gemInfo;
        } else {
            gemInfo = module != null ? GemSearchUtil.findGem(module, BUNDLER) : null;
            gemInfo = gemInfo == null ? GemSearchUtil.findGem(module, sdk, BUNDLER) : gemInfo;
        }
        return gemInfo;
    }

    public static void patchBundleExecCommandLine(@NotNull Sdk sdk, @Nullable Module module, @NotNull GeneralCommandLine cmdLine) {
        String string;
        String string2;
        long l2 = s ^ 0x21BF2586BB4L;
        if (sdk == null) {
            BundlerUtil.a(20);
        }
        if (cmdLine == null) {
            BundlerUtil.a(21);
        }
        if ((string2 = (String)cmdLine.getEnvironment().get("RUBYOPT")) != null) {
            string = string2.replace(RBUNDLER_SETUP, "");
            if (string.isEmpty()) {
                cmdLine.getEnvironment().remove("RUBYOPT");
            } else {
                cmdLine.withEnvironment("RUBYOPT", string);
            }
        }
        if ((string = RbenvGemsetManager.getShimsCommandPath(BUNDLE)) == null) {
            string = BundlerUtil.getBundlerScriptPath(sdk, module);
        }
        if (string != null) {
            String string3 = cmdLine.getExePath();
            cmdLine.withExePath(RubyVersionManagerHandler.notNullFrom(sdk).getAdjustedGemScriptPathForExecution(string));
            ParametersList parametersList = cmdLine.getParametersList();
            parametersList.addAt(0, "exec");
            int n2 = string3.lastIndexOf(Platform.current().fileSeparator);
            String string4 = n2 == -1 ? string3 : string3.substring(n2 + 1);
            parametersList.addAt(1, string4);
        }
    }

    public static String getBundlerScriptPath(@Nullable Sdk sdk, @Nullable Module module) {
        long l2 = s ^ 0x51ABD36A8ED8L;
        String string = RubyGemExecutionContext.getScriptPath(sdk, module, BUNDLER, BUNDLE);
        if (sdk == null && module != null) {
            sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        }
        return sdk == null || string == null ? string : RubySdkUtil.getDefaultPathMappings(sdk, module).convertToRemote(string);
    }

    private static void a(@Nullable Sdk sdk, @Nullable Module module, @NotNull GeneralCommandLine generalCommandLine, @NotNull String string, boolean bl2, boolean bl3) {
        Object object;
        String string2;
        String string3;
        Object object2;
        RubySdkSystemAccessor rubySdkSystemAccessor;
        RubySdkAdditionalData rubySdkAdditionalData;
        VirtualFile virtualFile;
        Map map;
        long l2 = s ^ 0x589B0635CB8BL;
        if (generalCommandLine == null) {
            BundlerUtil.a(22);
        }
        if (string == null) {
            BundlerUtil.a(23);
        }
        if ((map = generalCommandLine.getEnvironment()).isEmpty()) {
            return;
        }
        GemInfo gemInfo = BundlerUtil.getBundlerGem(sdk, bl3 ? null : module, true);
        VirtualFile virtualFile2 = gemInfo != null ? gemInfo.getLibFolder() : null;
        VirtualFile virtualFile3 = virtualFile = gemInfo != null ? gemInfo.getFile() : null;
        assert (virtualFile != null && virtualFile.isValid()) : "[ Bundler: " + gemInfo + "; File: " + virtualFile + "; Lib: " + virtualFile2 + "; ]";
        RubyRunner rubyRunner = BundlerUtil.a(sdk, module, generalCommandLine);
        if (sdk != null) {
            rubySdkAdditionalData = RubySdkUtil.getRubySdkAdditionalData(sdk);
            rubySdkSystemAccessor = rubySdkAdditionalData.getSdkSystemAccessor();
        } else {
            rubySdkSystemAccessor = LocalRubySdkSystemAccessor.getInstance();
        }
        rubySdkAdditionalData = rubyRunner.addDefaultMappings(null);
        map.put(c, rubySdkAdditionalData.convertToRemote(virtualFile.getPath() + "/bin"));
        VirtualFile virtualFile4 = BundlerUtil.getBundlerGemsDirFromConfig(module);
        if (virtualFile4 == null) {
            virtualFile4 = BundlerUtil.getDefaultBundleDir(sdk);
        }
        if (virtualFile4 != null) {
            object2 = FileUtil.toSystemDependentName((String)virtualFile4.getPath()) + File.separator + "bin";
            string3 = OSUtil.getPathEnvVariableName();
            string2 = OSUtil.prependToPathEnvVariable((String)map.get(string3), (String)object2);
            map.put(string3, string2);
        }
        object2 = BundlerUtil.getGemfile(module);
        assert (object2 != null);
        map.put(i, rubySdkAdditionalData.convertToRemote(object2.getPath()));
        string3 = (String)map.get("RUBYLIB");
        if (virtualFile2 != null) {
            string3 = OSUtil.prependToRUBYLIBEnvVariable(rubySdkSystemAccessor, string3, rubySdkAdditionalData.convertToRemote(virtualFile2.getPath()));
            map.put("RUBYLIB", string3);
        }
        string2 = "";
        if (RubyAbstractCommandLineState.isInRubyDebugMode(string) && !RubyMotionUtil.getInstance().isRubyMotionModule(module) && sdk != null) {
            try {
                object = RubyAbstractCommandLineState.selectDebugGemHelper(sdk, module, RubyDebugMode.NORMAL_MODE);
                if (object.needsDebugPreLoader()) {
                    String string4 = RubyUtil.getScriptFullPath("rb/gems");
                    assert (string4 != null);
                    string3 = OSUtil.prependToRUBYLIBEnvVariable(rubySdkSystemAccessor, string3, rubySdkAdditionalData.convertToRemote(string4));
                    map.put("RUBYLIB", string3);
                    string2 = string2 + "-rdebug_preloader.rb ";
                }
            }
            catch (ExecutionException executionException) {
                e.error((Throwable)executionException);
            }
        }
        string2 = string2 + RBUNDLER_SETUP;
        if (bl2) {
            string2 = string2 + " -rtest/unit/ui/teamcity/loadpath_patch.rb";
        }
        if (!StringUtil.isEmpty((String)(object = (String)map.get("RUBYOPT")))) {
            string2 = string2 + " " + (String)object;
        }
        map.put("RUBYOPT", string2);
    }

    public static void addBundlerEnvironment(@NotNull Map<String, String> env, @NotNull Sdk sdk, @Nullable Module module, @Nullable VirtualFile gemFile) {
        long l2 = s ^ 0x6107EE25A64FL;
        if (env == null) {
            BundlerUtil.a(24);
        }
        if (sdk == null) {
            BundlerUtil.a(25);
        }
        if (gemFile == null) {
            return;
        }
        RubyRunner rubyRunner = RunnerUtil.getRunner(sdk, module);
        env.put(i, rubyRunner.addDefaultMappings(null).convertToRemote(gemFile.getPath()));
    }

    @NotNull
    private static RubyRunner a(Sdk sdk, Module module, GeneralCommandLine generalCommandLine) {
        if (generalCommandLine instanceof RubyCommandLine) {
            RubyRunner rubyRunner = ((RubyCommandLine)generalCommandLine).getRunner();
            if (rubyRunner == null) {
                BundlerUtil.a(26);
            }
            return rubyRunner;
        }
        if (sdk != null) {
            RubySdkAdditionalData rubySdkAdditionalData = RubySdkUtil.getRubySdkAdditionalData(sdk);
            RubyRunner rubyRunner = rubySdkAdditionalData.getRunner(module);
            if (rubyRunner == null) {
                BundlerUtil.a(27);
            }
            return rubyRunner;
        }
        RubyLocalRunner rubyLocalRunner = RubyLocalRunner.getRunner(module);
        if (rubyLocalRunner == null) {
            BundlerUtil.a(28);
        }
        return rubyLocalRunner;
    }

    @NotNull
    public static List<String> getIgnoredGroupsFromConfig(Module module) {
        VirtualFile virtualFile = BundlerUtil.getConfigFile(module);
        List<String> list2 = BundlerUtil.b(virtualFile);
        List<String> list3 = list2.isEmpty() ? BundlerUtil.b(BundlerUtil.c()) : list2;
        if (list3 == null) {
            BundlerUtil.a(29);
        }
        return list3;
    }

    private static List<String> b(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        try {
            String string = VfsUtilCore.loadText((VirtualFile)virtualFile);
            Matcher matcher = k.matcher(string);
            if (matcher.find()) {
                return Arrays.asList(matcher.group(1).split(":"));
            }
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Nullable
    public static String addRVMBundleUrl(@NotNull Sdk sdk) {
        String string;
        long l2 = s ^ 0x742732198DL;
        if (sdk == null) {
            BundlerUtil.a(30);
        }
        if ((string = RVMSupportUtil.determineMainGemRootPath(sdk)) == null) {
            return null;
        }
        return VirtualFileUtil.constructLocalUrl(string) + p;
    }

    public static boolean isFakeRVMBundlerGemRootUrl(@NotNull String gemsRootUrl) {
        long l2 = s ^ 0x568C16FB8AE0L;
        if (gemsRootUrl == null) {
            BundlerUtil.a(31);
        }
        return gemsRootUrl.endsWith(p);
    }

    @Nullable
    public static VirtualFile getDefaultBundleDir(@Nullable Sdk sdk) {
        long l2 = s ^ 0x72D6C5A55759L;
        String string = SystemProperties.getUserHome() + f;
        VirtualFile virtualFile = BundlerUtil.a(sdk, string + d);
        if (virtualFile == null) {
            virtualFile = BundlerUtil.a(sdk, string + m);
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile a(@Nullable Sdk sdk, @NotNull String string) {
        if (string == null) {
            BundlerUtil.a(32);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(f).append(BundlerUtil.getSdkTypeStr(sdk));
        stringBuilder.append(f).append(BundlerUtil.getGemSdkVersion(sdk));
        return VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)stringBuilder.toString()));
    }

    public static boolean isNewBundler(GemInfo gem) {
        long l2 = s ^ 0x2252AE02F2ABL;
        return gem != null && !"bundler08".equals(gem.getName()) && VersionComparatorUtil.compare((String)gem.getVersion(), (String)"0.9") >= 0;
    }

    public static boolean isBundlerRuntimeEmulationEnabled(@NotNull Module module) {
        GemInfo gemInfo;
        long l2 = s ^ 0x4B5A21826A10L;
        if (module == null) {
            BundlerUtil.a(33);
        }
        return (gemInfo = GemSearchUtil.findGem(module, BUNDLER)) != null && gemInfo.isValid() && BundlerUtil.hasGemfile(module) && BundlerUtil.getGemfileLock(module) != null;
    }

    public static void enableBundleEmulationIfNeeded(@Nullable Module module, @NotNull AbstractRubyRunConfiguration<? extends AbstractRubyRunConfiguration> conf) {
        if (conf == null) {
            BundlerUtil.a(34);
        }
        if (module != null && BundlerUtil.isBundlerRuntimeEmulationEnabled(module)) {
            BundleExecSettings.putTo(conf, BundleExecSettings.createSettings(true));
        }
    }

    @Nullable
    private static VirtualFile a() {
        String string = RMInspectionToolLaunchSettings.getInstance().getGemFilePath();
        return LocalFileSystem.getInstance().findFileByPath(string);
    }

    public static boolean isGemMentioned(@NotNull RFile environmentConfigFile, @NotNull Sdk sdk, @NotNull String gemName) {
        if (environmentConfigFile == null) {
            BundlerUtil.a(35);
        }
        if (sdk == null) {
            BundlerUtil.a(36);
        }
        if (gemName == null) {
            BundlerUtil.a(37);
        }
        GemDetector gemDetector = GemRequirementsChangeWatcher.getDetector((PsiFile)environmentConfigFile);
        assert (gemDetector != null);
        Set<GemDependency> set = gemDetector.detect(environmentConfigFile.getProject(), sdk, environmentConfigFile.getVirtualFile());
        for (GemDependency gemDependency : set) {
            if (!gemDependency.getName().equals(gemName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<GemEnvironment> getGemEnvironments(Module module) {
        long l2 = s ^ 0x3267B92E0794L;
        HashSet<GemEnvironment> hashSet = new HashSet<GemEnvironment>();
        RFile rFile = BundlerUtil.getGemfilePsiFile(module);
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)rFile, RCall.class);
        if (!collection.isEmpty()) {
            for (RCall rCall : collection) {
                PsiElement psiElement;
                RPsiElement rPsiElement;
                String string = rCall.getCommand();
                if (!h.equals(string) || (rPsiElement = (RPsiElement)rCall.getArguments().get(0)) == null) continue;
                String string2 = rPsiElement.getName();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (string2 != null && (psiElement = rCall.getParent()) instanceof RDoBlockCall) {
                    RPsiElement rPsiElement2 = ((RDoBlockCall)psiElement).getLoopBody();
                    Collection collection2 = PsiTreeUtil.findChildrenOfType((PsiElement)rPsiElement2, RCall.class);
                    for (RCall rCall2 : collection2) {
                        List list2;
                        RPsiElement rPsiElement3;
                        String string3;
                        if (!GemCallTypeProvider.GEM_CALL.equals((Object)rCall2.getCallType()) || (string3 = (rPsiElement3 = (RPsiElement)(list2 = rCall2.getArguments()).get(0)) instanceof RStringLiteral ? ((RStringLiteral)rPsiElement3).getContent() : rPsiElement3.getName()) == null) continue;
                        arrayList.add(string3);
                    }
                }
                hashSet.add(new GemEnvironment(string2, arrayList));
            }
        }
        HashSet<GemEnvironment> hashSet2 = hashSet;
        if (hashSet2 == null) {
            BundlerUtil.a(38);
        }
        return hashSet2;
    }

    public static boolean isBundlerConfig(@Nullable VirtualFile file) {
        long l2 = s ^ 0x6FEAE5857BB5L;
        if (file == null || file.isDirectory()) {
            return false;
        }
        if (!CONFIG_FILE_NAME.equals(file.getName())) {
            return false;
        }
        return BundlerUtil.isBundlerDir(file.getParent());
    }

    public static boolean isBundlerDir(@Nullable VirtualFile dir) {
        long l2 = s ^ 0x4F1F8CAE79B2L;
        return dir != null && dir.isDirectory() && (m.equals(dir.getName()) || d.equals(dir.getName()));
    }

    @NotNull
    public static CmdlinePreprocessor getBundlerPreprocessor(@Nullable Sdk sdk, @Nullable Module module) {
        long l2 = s ^ 0x56A576A5E659L;
        CmdlinePreprocessor cmdlinePreprocessor = BundlerUtil.getBundlerPreprocessor(sdk, module, "RubyProgramRunner", false, false);
        if (cmdlinePreprocessor == null) {
            BundlerUtil.a(39);
        }
        return cmdlinePreprocessor;
    }

    private static boolean a(@Nullable Sdk sdk, @Nullable Module module) {
        RubySdkSystemAccessor rubySdkSystemAccessor = RubySdkSystemAccessor.from(RubySdkUtil.getEffectiveSdk(sdk, module));
        return rubySdkSystemAccessor != null ? rubySdkSystemAccessor.isWindows() : SystemInfo.isWindows;
    }

    @NotNull
    public static CmdlinePreprocessor getBundlerPreprocessor(final @Nullable Sdk sdk, final @Nullable Module module, final @NotNull String runnerId, final boolean patchForTests, final boolean useAlternativeSdk) {
        if (runnerId == null) {
            BundlerUtil.a(40);
        }
        CmdlinePreprocessor cmdlinePreprocessor = new CmdlinePreprocessor(){
            private static final long a = la.a(-1351086490235949507L, 5482025314830900137L, MethodHandles.lookup().lookupClass()).a(142698507248689L);

            @Override
            public void preprocess(@NotNull GeneralCommandLine cmdline) {
                long l2 = a ^ 0x36CFFA0AC3C7L;
                if (cmdline == null) {
                    1.a(0);
                }
                if (module == null || !BundlerUtil.isBundlerRuntimeEmulationEnabled(module)) {
                    return;
                }
                if (Experiments.isFeatureEnabled((String)"ruby.force.explicit.bundle.exec")) {
                    String string = cmdline.getExePath();
                    String string2 = BundlerUtil.a(sdk, module) ? BundlerUtil.a : BundlerUtil.BUNDLE;
                    Path path = ShimsBasedVersionManagerHandler.shimsPathFor(sdk, module);
                    cmdline.withExePath(path == null ? string2 : path.resolve(string2).toString());
                    ParametersList parametersList = cmdline.getParametersList();
                    parametersList.addAt(0, "exec");
                    parametersList.addAt(1, string);
                } else {
                    ReadAction.run(() -> {
                        if (cmdline == null) {
                            1.a(1);
                        }
                        if (runnerId == null) {
                            1.a(2);
                        }
                        BundlerUtil.a(sdk, module, cmdline, runnerId, patchForTests, useAlternativeSdk);
                        if (RbenvGemsetManager.isRbenvSdk(sdk) && !RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk)) {
                            BundlerUtil.patchBundleExecCommandLine(sdk, module, cmdline);
                        }
                    });
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x47C7002794CFL;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cmdline";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runnerId";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/util/BundlerUtil$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "preprocess";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$preprocess$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (cmdlinePreprocessor == null) {
            BundlerUtil.a(41);
        }
        return cmdlinePreprocessor;
    }

    public static Collection<VirtualFile> getAllGemfiles(@NotNull Project project) {
        long l2 = s ^ 0x2FD260C0EC90L;
        if (project == null) {
            BundlerUtil.a(42);
        }
        Collection collection = FilenameIndex.getVirtualFilesByName((Project)project, (String)q, (boolean)true, (GlobalSearchScope)ProjectScope.getContentScope((Project)project));
        collection.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)r, (boolean)true, (GlobalSearchScope)ProjectScope.getContentScope((Project)project)));
        return collection;
    }

    @Nullable
    public static String getLockFilePath(@NotNull Module module) {
        VirtualFile virtualFile;
        if (module == null) {
            BundlerUtil.a(43);
        }
        if ((virtualFile = BundlerUtil.getGemfileLock(module)) != null) {
            return virtualFile.getPath();
        }
        VirtualFile virtualFile2 = BundlerUtil.getGemfile(module);
        if (virtualFile2 != null) {
            return new File(virtualFile2.getParent().getPath(), BundlerUtil.a(virtualFile2)).getAbsolutePath();
        }
        return null;
    }

    static {
        s = la.a(6338483826128676137L, -3816728620336003388L, MethodHandles.lookup().lookupClass()).a(30450996385418L);
        long l2 = s ^ 0x7014E10BD95AL;
        o = new String[]{q, r};
        e = Logger.getInstance(BundlerUtil.class);
        l = FileUtil.join((String[])new String[]{m, CONFIG_FILE_NAME});
        g = Pattern.compile("^\\s*BUNDLE_PATH:\\s*(.*)$", 8);
        k = Pattern.compile("^\\s*BUNDLE_WITHOUT:\\s*(.*)$", 8);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = s ^ 0x702BA11BBAFEL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 39: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 39: 
            case 41: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemfile";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/util/BundlerUtil";
                break;
            }
            case 20: 
            case 25: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 23: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemsRootUrl";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundlePath";
                break;
            }
            case 33: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentConfigFile";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/util/BundlerUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLockFileName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemSdkVersion";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkTypeStr";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredGroupsFromConfig";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemEnvironments";
                break;
            }
            case 39: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundlerPreprocessor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openGemFileInEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addBinIfExists";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileInModuleRoot";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGemfile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLockFileName";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 39: 
            case 41: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isGemfile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBundlePath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "patchBundleExecCommandLine";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addBundlerEnvironment";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addRVMBundleUrl";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isFakeRVMBundlerGemRootUrl";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findGemFolderForSdk";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isBundlerRuntimeEmulationEnabled";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "enableBundleEmulationIfNeeded";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isGemMentioned";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getBundlerPreprocessor";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAllGemfiles";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getLockFilePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 39: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

