/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.BooleanValue;

public class Exists
extends Aggregate
implements Negatable,
Callable {
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 8;
    }

    public boolean isNegatable(ExpressionVisitor visitor) {
        return true;
    }

    public Expression negate() {
        FunctionCall fc = SystemFunctionCall.makeSystemFunction("empty", this.getArguments());
        fc.setLocationId(this.getLocationId());
        return fc;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        VennExpression v;
        Expression e2 = super.optimize(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        int c = this.argument[0].getCardinality();
        if (c == 49152) {
            return Literal.makeLiteral(BooleanValue.TRUE);
        }
        if (c == 8192) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        this.argument[0] = ExpressionTool.unsorted(visitor.getConfiguration().obtainOptimizer(), this.argument[0], false);
        if (this.argument[0] instanceof VennExpression && !visitor.isOptimizeForStreaming() && (v = (VennExpression)this.argument[0]).getOperator() == 1) {
            FunctionCall e0 = SystemFunctionCall.makeSystemFunction("exists", new Expression[]{v.getOperands()[0]});
            FunctionCall e1 = SystemFunctionCall.makeSystemFunction("exists", new Expression[]{v.getOperands()[1]});
            return new OrExpression(e0, e1).optimize(visitor, contextItemType);
        }
        return this;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        try {
            return Exists.exists(this.argument[0].iterate(c));
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            err.maybeSetContext(c);
            throw err;
        }
    }

    private static boolean exists(SequenceIterator iter) throws XPathException {
        boolean result = (iter.getProperties() & 4) != 0 ? ((LookaheadIterator)iter).hasNext() : iter.next() != null;
        iter.close();
        return result;
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        try {
            return BooleanValue.get(Exists.exists(arguments[0].iterate()));
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            err.maybeSetContext(context);
            throw err;
        }
    }
}

