/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLCallTemplate
extends StyleElement {
    private StructuredQName calledTemplateName;
    private XSLTemplate template = null;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private boolean gettingReturnedItemType = false;

    protected boolean allowAVT() {
        return false;
    }

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.template == null || this.gettingReturnedItemType) {
            return AnyItemType.getInstance();
        }
        this.gettingReturnedItemType = true;
        ItemType result = this.template.getReturnedItemType();
        this.gettingReturnedItemType = false;
        return result;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String nameAttribute = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                nameAttribute = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (nameAttribute == null) {
            this.calledTemplateName = new StructuredQName("saxon", "http://saxon.sf.net/", "error-template");
            this.reportAbsence("name");
            return;
        }
        if (this.allowAVT() && nameAttribute.indexOf(123) >= 0) {
            this.calledTemplateExpression = this.makeAttributeValueTemplate(nameAttribute);
        } else {
            try {
                this.calledTemplateName = this.makeQName(nameAttribute);
            }
            catch (NamespaceException err) {
                this.calledTemplateName = new StructuredQName("saxon", "http://saxon.sf.net/", "error-template");
                this.compileError(err.getMessage(), "XTSE0280");
            }
            catch (XPathException err) {
                this.calledTemplateName = new StructuredQName("saxon", "http://saxon.sf.net/", "error-template");
                this.compileError(err.getMessage(), err.getErrorCodeQName());
            }
        }
    }

    public void validate(Declaration decl) throws XPathException {
        Object child;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLWithParam || child instanceof XSLFallback && this.mayContainFallback()) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:call-template", "XTSE0010");
                continue;
            }
            this.compileError("Child element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed as a child of xsl:call-template", "XTSE0010");
        }
        if (!(this.calledTemplateExpression != null || this.calledTemplateName.getURI().equals("http://saxon.sf.net/") && this.calledTemplateName.getLocalPart().equals("error-template"))) {
            this.template = this.findTemplate(this.calledTemplateName);
            if (this.template == null) {
                return;
            }
        }
        this.calledTemplateExpression = this.typeCheck("name", this.calledTemplateExpression);
    }

    public void postValidate() throws XPathException {
        if (this.template != null) {
            Object w;
            Object param;
            AxisIterator declaredParams = this.template.iterateAxis((byte)3);
            while ((param = declaredParams.next()) != null) {
                Object withParam;
                if (!(param instanceof XSLLocalParam) || !((XSLLocalParam)param).isRequiredParam() || ((XSLLocalParam)param).isTunnelParam()) continue;
                AxisIterator actualParams = this.iterateAxis((byte)3);
                boolean ok = false;
                while ((withParam = actualParams.next()) != null) {
                    if (!(withParam instanceof XSLWithParam) || !((XSLWithParam)withParam).getVariableQName().equals(((XSLLocalParam)param).getVariableQName())) continue;
                    ok = true;
                    break;
                }
                if (ok) continue;
                this.compileError("No value supplied for required parameter " + Err.wrap(((XSLLocalParam)param).getVariableQName().getDisplayName(), 5), "XTSE0690");
            }
            AxisIterator actualParams = this.iterateAxis((byte)3);
            while ((w = actualParams.next()) != null) {
                Object param2;
                if (!(w instanceof XSLWithParam) || ((XSLWithParam)w).isTunnelParam()) continue;
                XSLWithParam withParam = (XSLWithParam)w;
                assert (this.template != null);
                AxisIterator formalParams = this.template.iterateAxis((byte)3);
                boolean ok = false;
                while ((param2 = formalParams.next()) != null) {
                    if (!(param2 instanceof XSLLocalParam) || !((XSLLocalParam)param2).getVariableQName().equals(withParam.getVariableQName())) continue;
                    ok = true;
                    SequenceType required = ((XSLLocalParam)param2).getRequiredType();
                    withParam.checkAgainstRequiredType(required);
                    break;
                }
                if (ok || this.xPath10ModeIsEnabled()) continue;
                this.compileError("Parameter " + withParam.getVariableQName().getDisplayName() + " is not declared in the called template", "XTSE0680");
            }
        }
    }

    private XSLTemplate findTemplate(StructuredQName templateName) throws XPathException {
        PrincipalStylesheetModule psm = this.getPrincipalStylesheetModule();
        XSLTemplate template = psm.getNamedTemplate(templateName);
        if (template == null) {
            this.compileError("No template exists named " + this.calledTemplateName, "XTSE0650");
        }
        return template;
    }

    public boolean markTailCalls() {
        this.useTailRecursion = true;
        return true;
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        Template target = null;
        SavedNamespaceContext nsContext = null;
        if (this.calledTemplateExpression == null) {
            if (this.template == null) {
                return null;
            }
            target = this.template.getCompiledTemplate();
        } else {
            nsContext = this.makeNamespaceContext();
        }
        CallTemplate call = new CallTemplate(target, this.useTailRecursion, this.calledTemplateExpression, nsContext);
        call.setActualParameters(this.getWithParamInstructions(exec, decl, false, call), this.getWithParamInstructions(exec, decl, true, call));
        return call;
    }
}

