/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileListTransferable
implements Transferable,
ClipboardOwner {
    private List fileList;
    private DataFlavor uriListFlavor;

    public FileListTransferable(List fileList) {
        this.fileList = fileList;
        try {
            this.uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (DataFlavor.javaFileListFlavor.equals(flavor)) {
            return new ArrayList(this.fileList);
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            StringBuffer sb = new StringBuffer();
            if (this.fileList != null) {
                for (File f : this.fileList) {
                    sb.append(f.getAbsolutePath()).append('\n');
                }
            }
            return ((Object)sb.subSequence(0, sb.length() - 1)).toString();
        }
        if (this.uriListFlavor.equals(flavor)) {
            StringBuffer sb = new StringBuffer();
            if (this.fileList != null) {
                for (File f : this.fileList) {
                    String uri = f.toURI().toString();
                    if (uri.startsWith("file:/") && uri.length() > 6 && uri.charAt(6) != '/') {
                        uri = "file://localhost/" + uri.substring(6);
                    }
                    sb.append(uri).append("\r\n");
                }
            }
            System.out.println("Transferring:\n" + sb.toString());
            return sb.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>();
        flavors.add(DataFlavor.javaFileListFlavor);
        if (this.uriListFlavor != null) {
            flavors.add(this.uriListFlavor);
        }
        flavors.add(DataFlavor.stringFlavor);
        return flavors.toArray(new DataFlavor[flavors.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

