package TDS::CapturedAntenna::Item;
# $Id: CapturedAntenna.pm,v 1.4 2000/12/25 05:46:51 tom Exp $
################################################################

use strict;
use vars qw(@ISA
	    $Template $BannerTemplate);

use Container::Item;
use Template;

use TDS::DirInfo;

@ISA = qw(Container::Item);

#$Template = qq([<a href="%Url">%Name</a>]);
$Template = qq(<a href="%url">[%name]</a> ) unless defined $Template;
$BannerTemplate = qq(<a href="%url"><img src="%banner_url" width="88" height="31" border="0"></a>) unless defined $BannerTemplate;

attributes qw();

################################################################
sub SetByLine($$)
{
    my ($self, $line) = @_;
    chomp $line;

    my @tmp = split(/\t+/, $line);
    $self->Set('name', $tmp[0]);
#    my @tmp2 = split(/, */, $tmp[1]);
    $self->Set('url', $tmp[1]);    
    $self->Set('banner_url', $tmp[2]);
}
sub convert_tag ($$)
{
    my ($self, $tag) = @_;
    return $tag;
}
sub AsHTML($)
{
    my $self = shift;

    my $template = ($self->Value('banner_url')) ? $BannerTemplate : $Template;
    return Expand($template, $self->GetParams);
}

################################################################
################################################################
package TDS::CapturedAntenna;

use strict;
use vars qw(@ISA);

use Container;

use TDS::DirInfo;

@ISA = qw(Container);

attributes qw(filename);

################################################################

sub initialize($)
{
    my $self = shift;

    $self->filename(GetDataDir() . "/captured_antenna.dat")
	unless $self->filename;
    $self->SUPER::initialize;
}
sub CreateItem($)
{
    my $self = shift;
    return new TDS::CapturedAntenna::Item;
}
sub AsHTML($)
{
    my $self = shift;

    my $html = "";
    
    for (@{$self->content}){
	$html .= $_->AsHTML;
    }
    return $html;
}
1;
